/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.util.core.internal.exported.AbstractRegistry;
import org.eclipse.modisco.facet.widgets.celleditors.ICellEditorsRegistry;
import org.eclipse.modisco.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.IModelCellEditorContainer;
import org.eclipse.modisco.facet.widgets.celleditors.INaryFeatureCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.internal.Activator;
import org.eclipse.modisco.facet.widgets.celleditors.internal.ModelCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.internal.ModelCellEditorContainer;
import org.eclipse.modisco.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.modelCellEditor.BasicCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.modelCellEditor.ModelCellEditorDeclarations;
import org.eclipse.modisco.facet.widgets.celleditors.modelCellEditor.NaryFeatureCellEditor;
import org.eclipse.modisco.facet.widgets.celleditors.modelCellEditor.UnaryReferenceCellEditor;

public class CellEditorsRegistry
extends AbstractRegistry
implements ICellEditorsRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.facet.widgets.celleditors";
    private static final String EXTENSION_POINT_NAME = "celleditors";
    private static final String CELL_EDITORS_MODEL_ELEMENT = "cellEditorsModel";
    private static final String PATH_ATTRIBUTE = "path";
    private final List<ModelCellEditorContainer<BasicCellEditor>> basicCellEditors = new ArrayList<ModelCellEditorContainer<BasicCellEditor>>();
    private final List<ModelCellEditorContainer<UnaryReferenceCellEditor>> unaryReferenceCellEditors = new ArrayList<ModelCellEditorContainer<UnaryReferenceCellEditor>>();
    private final List<ModelCellEditorContainer<NaryFeatureCellEditor>> naryFeatureCellEditors = new ArrayList<ModelCellEditorContainer<NaryFeatureCellEditor>>();

    public CellEditorsRegistry() {
        this.initialize();
    }

    @Override
    public List<IModelCellEditorContainer<? extends AbstractModelCellEditor>> getAllCellEditors() {
        ArrayList<IModelCellEditorContainer<? extends AbstractModelCellEditor>> allCellEditors = new ArrayList<IModelCellEditorContainer<? extends AbstractModelCellEditor>>();
        for (ModelCellEditorContainer<BasicCellEditor> modelCellEditorContainer : this.basicCellEditors) {
            allCellEditors.add(modelCellEditorContainer);
        }
        for (ModelCellEditorContainer<AbstractModelCellEditor> modelCellEditorContainer : this.unaryReferenceCellEditors) {
            allCellEditors.add(modelCellEditorContainer);
        }
        for (ModelCellEditorContainer<AbstractModelCellEditor> modelCellEditorContainer : this.naryFeatureCellEditors) {
            allCellEditors.add(modelCellEditorContainer);
        }
        return allCellEditors;
    }

    public ModelCellEditor getCellEditorWrapperFor(EClassifier type, boolean many) {
        return this.getCellEditorWrapperFor(type, many, null);
    }

    @Override
    public IModelCellEditor getCellEditorFor(EClassifier type) {
        ModelCellEditor cellEditorWrapper = this.getCellEditorWrapperFor(type, false);
        if (cellEditorWrapper != null) {
            return (IModelCellEditor)cellEditorWrapper.getCellEditorImplementation();
        }
        return null;
    }

    @Override
    public INaryFeatureCellEditor getNaryCellEditorFor(EClassifier type) {
        ModelCellEditor cellEditorWrapper = this.getCellEditorWrapperFor(type, true);
        if (cellEditorWrapper != null) {
            return (INaryFeatureCellEditor)cellEditorWrapper.getCellEditorImplementation();
        }
        return null;
    }

    @Override
    public IModelCellEditor getCellEditorFor(EClassifier type, List<AbstractModelCellEditor> preferredCellEditors) {
        ModelCellEditor cellEditorWrapper = this.getCellEditorWrapperFor(type, false, preferredCellEditors);
        if (cellEditorWrapper != null) {
            return (IModelCellEditor)cellEditorWrapper.getCellEditorImplementation();
        }
        return null;
    }

    @Override
    public INaryFeatureCellEditor getNaryCellEditorFor(EClassifier type, List<AbstractModelCellEditor> preferredCellEditors) {
        ModelCellEditor cellEditorWrapper = this.getCellEditorWrapperFor(type, true, preferredCellEditors);
        if (cellEditorWrapper != null) {
            return (INaryFeatureCellEditor)cellEditorWrapper.getCellEditorImplementation();
        }
        return null;
    }

    public ModelCellEditor getCellEditorWrapperFor(EClassifier type, boolean many, List<AbstractModelCellEditor> preferredCellEditors) {
        List<IModelCellEditorContainer<? extends AbstractModelCellEditor>> allCellEditorContainers = this.getAllCellEditors();
        ArrayList<ModelCellEditor> cellEditors = new ArrayList<ModelCellEditor>();
        for (IModelCellEditorContainer<? extends AbstractModelCellEditor> modelCellEditorContainer : allCellEditorContainers) {
            AbstractModelCellEditor modelCellEditor = modelCellEditorContainer.getModelCellEditor();
            if (!CellEditorsRegistry.isCellEditorForType(modelCellEditor, type, many)) continue;
            cellEditors.add(new ModelCellEditor(modelCellEditorContainer.getBundleName(), modelCellEditorContainer.getModelCellEditor()));
        }
        ModelCellEditor selectedCellEditor = null;
        if (preferredCellEditors != null) {
            for (AbstractModelCellEditor preferredCellEditor : preferredCellEditors) {
                if (!CellEditorsRegistry.isCellEditorForType(preferredCellEditor, type, many)) continue;
                if (selectedCellEditor != null) {
                    throw new IllegalArgumentException("Several preferred cell editors are defined for type: " + String.valueOf(EcoreUtil.getURI((EObject)type)));
                }
                selectedCellEditor = new ModelCellEditor("", preferredCellEditor);
            }
        }
        if (selectedCellEditor == null) {
            if (cellEditors.size() == 1) {
                selectedCellEditor = (ModelCellEditor)cellEditors.get(0);
            } else if (cellEditors.size() > 1) {
                boolean skippedDefault = false;
                for (ModelCellEditor cellEditor : cellEditors) {
                    if (cellEditor.getBundleName().startsWith(EXTENSION_POINT_NAMESPACE)) {
                        if (skippedDefault) {
                            Logger.logError((String)("Several default cell editors are defined in EMF Facet for type: " + String.valueOf(EcoreUtil.getURI((EObject)type))), (Plugin)Activator.getDefault());
                            selectedCellEditor = cellEditor;
                            break;
                        }
                        skippedDefault = true;
                        continue;
                    }
                    if (selectedCellEditor != null) {
                        Logger.logWarning((String)("Several cell editors are defined for type: " + String.valueOf(EcoreUtil.getURI((EObject)type))), (Plugin)Activator.getDefault());
                        break;
                    }
                    selectedCellEditor = cellEditor;
                }
            }
        }
        return selectedCellEditor;
    }

    public static boolean isCellEditorForType(AbstractModelCellEditor modelCellEditor, EClassifier type, boolean many) {
        if (many != modelCellEditor instanceof NaryFeatureCellEditor) {
            return false;
        }
        return CellEditorsRegistry.isSuperType(modelCellEditor.getCellType(), type);
    }

    private static boolean isSuperType(EClassifier superType, EClassifier subType) {
        if (superType == subType) {
            return true;
        }
        if (superType instanceof EClass && subType instanceof EClass) {
            if (superType == EcorePackage.eINSTANCE.getEObject()) {
                return true;
            }
            EClass superTypeEClass = (EClass)superType;
            EClass subTypeEClass = (EClass)subType;
            return superTypeEClass.isSuperTypeOf(subTypeEClass);
        }
        return superType == EcorePackage.eINSTANCE.getEDataType() && subType instanceof EDataType;
    }

    public List<ModelCellEditorContainer<BasicCellEditor>> getBasicCellEditors() {
        return this.basicCellEditors;
    }

    public List<ModelCellEditorContainer<UnaryReferenceCellEditor>> getUnaryReferenceCellEditors() {
        return this.unaryReferenceCellEditors;
    }

    public List<ModelCellEditorContainer<NaryFeatureCellEditor>> getNaryFeatureCellEditors() {
        return this.naryFeatureCellEditors;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(CELL_EDITORS_MODEL_ELEMENT)) {
            this.readModelElement(configurationElement);
        } else {
            CellEditorsRegistry.logUnknownElement((IConfigurationElement)configurationElement);
        }
    }

    private void readModelElement(IConfigurationElement configurationElement) {
        String path = configurationElement.getAttribute(PATH_ATTRIBUTE);
        String bundleName = configurationElement.getContributor().getName();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)("platform:/plugin/" + configurationElement.getContributor().getName() + "/" + path));
        Resource resource = resourceSet.getResource(uri, true);
        if (resource != null) {
            EList contents = resource.getContents();
            if (contents.size() == 1) {
                EObject eObject = (EObject)contents.get(0);
                if (eObject instanceof ModelCellEditorDeclarations) {
                    ModelCellEditorDeclarations modelCellEditors = (ModelCellEditorDeclarations)eObject;
                    EList<AbstractModelCellEditor> allCellEditors = modelCellEditors.getModelCellEditors();
                    for (AbstractModelCellEditor modelCellEditor : allCellEditors) {
                        ModelCellEditorContainer modelCellEditorContainer;
                        if (modelCellEditor instanceof BasicCellEditor) {
                            BasicCellEditor basicCellEditor = (BasicCellEditor)modelCellEditor;
                            modelCellEditorContainer = new ModelCellEditorContainer();
                            modelCellEditorContainer.setBundleName(bundleName);
                            modelCellEditorContainer.setModelCellEditor(basicCellEditor);
                            this.basicCellEditors.add(modelCellEditorContainer);
                            continue;
                        }
                        if (modelCellEditor instanceof UnaryReferenceCellEditor) {
                            UnaryReferenceCellEditor unaryReferenceCellEditor = (UnaryReferenceCellEditor)modelCellEditor;
                            modelCellEditorContainer = new ModelCellEditorContainer();
                            modelCellEditorContainer.setBundleName(bundleName);
                            modelCellEditorContainer.setModelCellEditor(unaryReferenceCellEditor);
                            this.unaryReferenceCellEditors.add(modelCellEditorContainer);
                            continue;
                        }
                        if (modelCellEditor instanceof NaryFeatureCellEditor) {
                            NaryFeatureCellEditor naryFeatureCellEditor = (NaryFeatureCellEditor)modelCellEditor;
                            modelCellEditorContainer = new ModelCellEditorContainer();
                            modelCellEditorContainer.setBundleName(bundleName);
                            modelCellEditorContainer.setModelCellEditor(naryFeatureCellEditor);
                            this.naryFeatureCellEditors.add(modelCellEditorContainer);
                            continue;
                        }
                        Logger.logError((String)("Not handled: " + modelCellEditor.getClass().getSimpleName()), (Plugin)Activator.getDefault());
                    }
                } else {
                    Logger.logError((String)("Root element must be of type " + ModelCellEditorDeclarations.class.getSimpleName() + ": " + String.valueOf(uri)), (Plugin)Activator.getDefault());
                }
            } else {
                Logger.logError((String)("Resource should have one and only one root: " + String.valueOf(uri)), (Plugin)Activator.getDefault());
            }
        } else {
            Logger.logError((String)("Error reading resource: " + String.valueOf(uri)), (Plugin)Activator.getDefault());
        }
    }
}

