/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.uicore.internal.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.browser.uicore.extensions.icons.FilteredIconProvider;
import org.eclipse.modisco.infra.browser.uicore.extensions.icons.IconProvider;
import org.eclipse.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.modisco.infra.browser.uicore.internal.Messages;
import org.eclipse.modisco.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.swt.graphics.Image;

@Deprecated
public class IconProvidersRegistry
extends AbstractRegistry {
    private static final String METACLASS_ELEMENT = "metaclass";
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.infra.browser.uicore";
    private static final String EXTENSION_POINT_NAME = "icons";
    private static final String METAMODEL_ID_ATTRIBUTE = "id";
    private static final String METAMODEL_ELEMENT = "metamodel";
    private static final String ICON_PROVIDER_ELEMENT = "iconProvider";
    private static final String ICON_PROVIDER_CLASS = "class";
    private static final String FILTER_ELEMENT = "filter";
    private static final String METACLASS_NAME_ATTRIBUTE = "name";
    private static IconProvidersRegistry instance = null;
    private final Map<String, List<FilteredIconProvider>> iconProviders = new HashMap<String, List<FilteredIconProvider>>();

    public static IconProvidersRegistry getInstance() {
        if (instance == null) {
            instance = new IconProvidersRegistry();
        }
        return instance;
    }

    public IconProvidersRegistry() {
        this.initialize();
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    public Image getIcon(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            return null;
        }
        String metaclassQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            return null;
        }
        String nsURI = ePackage.getNsURI();
        List<FilteredIconProvider> filteredIconProviders = this.iconProviders.get(nsURI);
        if (filteredIconProviders == null && (filteredIconProviders = this.iconProviders.get("*")) == null) {
            return null;
        }
        for (FilteredIconProvider filteredIconProvider : filteredIconProviders) {
            Image icon;
            if (!filteredIconProvider.filter(metaclassQualifiedName) || (icon = filteredIconProvider.getIcon(eObject)) == null) continue;
            return icon;
        }
        return null;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(METAMODEL_ELEMENT)) {
            this.readMetamodelElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readMetamodelElement(IConfigurationElement configurationElement) {
        IConfigurationElement[] children;
        String metamodelId = configurationElement.getAttribute(METAMODEL_ID_ATTRIBUTE);
        if (metamodelId == null) {
            this.logMissingAttribute(configurationElement, METAMODEL_ID_ATTRIBUTE);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName();
            if (name.equalsIgnoreCase(ICON_PROVIDER_ELEMENT)) {
                this.readIconProviderElement(child, metamodelId);
            } else {
                this.logUnknownElement(configurationElement);
            }
            ++n2;
        }
    }

    private void readIconProviderElement(IConfigurationElement configurationElement, String metamodelId) {
        Object iconProviderObject;
        HashSet<String> filteredMetaclasses = null;
        IConfigurationElement[] filterElements = configurationElement.getChildren(FILTER_ELEMENT);
        if (filterElements.length > 0) {
            IConfigurationElement[] metaclassElements;
            IConfigurationElement[] iConfigurationElementArray = metaclassElements = filterElements[0].getChildren(METACLASS_ELEMENT);
            int n = metaclassElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaclassElement = iConfigurationElementArray[n2];
                String metaclassName = metaclassElement.getAttribute(METACLASS_NAME_ATTRIBUTE);
                if (metaclassName != null) {
                    if (filteredMetaclasses == null) {
                        filteredMetaclasses = new HashSet<String>();
                    }
                    filteredMetaclasses.add(metaclassName);
                }
                ++n2;
            }
        }
        final HashSet<String> fFilteredMetaclasses = filteredMetaclasses;
        try {
            iconProviderObject = configurationElement.createExecutableExtension(ICON_PROVIDER_CLASS);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return;
        }
        if (iconProviderObject == null) {
            this.logMissingAttribute(configurationElement, ICON_PROVIDER_CLASS);
            return;
        }
        List<FilteredIconProvider> filteredIconProviders = this.iconProviders.get(metamodelId);
        if (filteredIconProviders == null) {
            filteredIconProviders = new ArrayList<FilteredIconProvider>();
        }
        if (iconProviderObject instanceof FilteredIconProvider) {
            final FilteredIconProvider filteredIconProvider = (FilteredIconProvider)iconProviderObject;
            filteredIconProviders.add(new FilteredIconProvider(){

                @Override
                public Image getIcon(EObject object) {
                    return filteredIconProvider.getIcon(object);
                }

                @Override
                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses != null && !fFilteredMetaclasses.contains(metaclass)) {
                        return false;
                    }
                    return filteredIconProvider.filter(metaclass);
                }
            });
        } else if (iconProviderObject instanceof IconProvider) {
            final IconProvider iconProvider = (IconProvider)iconProviderObject;
            FilteredIconProvider filteredNameProvider = new FilteredIconProvider(){

                @Override
                public Image getIcon(EObject object) {
                    return iconProvider.getIcon(object);
                }

                @Override
                public boolean filter(String metaclass) {
                    if (fFilteredMetaclasses == null) {
                        return true;
                    }
                    return fFilteredMetaclasses.contains(metaclass);
                }
            };
            filteredIconProviders.add(filteredNameProvider);
        } else {
            this.logError(configurationElement, Messages.IconProvidersRegistry_notAnIconProvider);
        }
        this.iconProviders.put(metamodelId, filteredIconProviders);
    }
}

