/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;

public class MoDiscoProject
implements IProjectNature {
    private IProject project;
    public static final String NATURE_ID = "org.eclipse.modisco.common.ProjectNature";

    public static boolean isInMoDiscoProject(IPath path) {
        IProject project;
        if (path.segmentCount() == 1) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        } else {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            project = folder.getProject();
        }
        return MoDiscoProject.isMoDiscoProject(project);
    }

    public static boolean isMoDiscoProject(IProject project) {
        block3: {
            try {
                if (project.isAccessible()) break block3;
                return false;
            }
            catch (CoreException e) {
                Logger.logError((Throwable)e, (Plugin)CommonModiscoActivator.getDefault());
                return false;
            }
        }
        return project.getNature(NATURE_ID) != null;
    }

    public void configure() throws CoreException {
        IProjectDescription projectDescription = this.project.getDescription();
        ICommand[] oldBuildSpec = this.project.getDescription().getBuildSpec();
        ICommand[] newBuildSpec = new ICommand[oldBuildSpec.length + 1];
        System.arraycopy(oldBuildSpec, 0, newBuildSpec, 0, oldBuildSpec.length);
        ICommand command = this.project.getDescription().newCommand();
        command.setBuilderName("org.eclipse.modisco.common.core.builder");
        newBuildSpec[oldBuildSpec.length] = command;
        projectDescription.setBuildSpec(newBuildSpec);
        this.project.setDescription(projectDescription, (IProgressMonitor)new NullProgressMonitor());
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject value) {
        this.project = value;
    }
}

