/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.common.core.files.FileUtils;
import org.eclipse.modisco.common.core.files.IFilter;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.osgi.framework.Bundle;

@Deprecated
public final class FolderUtils {
    private static final int COPY_BUFFER_SIZE = 524288;
    private static boolean debug = false;
    private static ConfigurationManagementFilter configurationManagementFilter;

    private FolderUtils() {
    }

    @Deprecated
    public static final void clearFolder(File dirtyFolder) {
        File[] files;
        assert (dirtyFolder != null);
        assert (dirtyFolder.exists());
        assert (dirtyFolder.isDirectory());
        File[] fileArray = files = dirtyFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderUtils.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    @Deprecated
    public static final boolean compareFolders(File folderSource, File folderTarget) {
        return FolderUtils.compareFolders(folderSource, folderTarget, configurationManagementFilter, FolderUtils.getDefaultFileComparator());
    }

    @Deprecated
    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter) {
        return FolderUtils.compareFolders(folderSource, folderTarget, filter, FolderUtils.getDefaultFileComparator());
    }

    @Deprecated
    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        assert (folderSource != null && folderTarget != null);
        assert (folderSource.isDirectory() && folderTarget.isDirectory());
        boolean result = false;
        if (folderSource.equals(folderTarget)) {
            result = true;
        } else {
            result = FolderUtils.recursiveCompareFolders(folderSource, folderTarget, filter, fileComparison);
            if (debug && !result) {
                Logger.logError((String)("folders " + folderSource.getName() + " and " + folderTarget.getName() + " are not equal."), (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        return result;
    }

    @Deprecated
    public static final boolean compareFiles(File source, File target) {
        return FolderUtils.compareFiles(source, target, FolderUtils.getDefaultFileComparator());
    }

    @Deprecated
    private static final Comparator<File> getDefaultFileComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File source, File target) {
                boolean result;
                block33: {
                    result = true;
                    if (!source.getName().equals(target.getName())) {
                        result = false;
                    } else {
                        BufferedReader targetReader;
                        block34: {
                            BufferedReader sourceReader = null;
                            targetReader = null;
                            try {
                                sourceReader = new BufferedReader(new FileReader(source));
                                targetReader = new BufferedReader(new FileReader(target));
                                String sourceLine = sourceReader.readLine();
                                String targetLine = targetReader.readLine();
                                while (sourceLine != null && targetLine != null) {
                                    result = result && sourceLine.equals(targetLine);
                                    sourceLine = sourceReader.readLine();
                                    targetLine = targetReader.readLine();
                                }
                                if (sourceLine != null || targetLine != null) {
                                    result = false;
                                    Logger.logError((String)"These files do not have the same number of lines.", (Plugin)CommonModiscoActivator.getDefault());
                                }
                            }
                            catch (FileNotFoundException e) {
                                result = false;
                                if (sourceReader != null) {
                                    try {
                                        sourceReader.close();
                                    }
                                    catch (IOException e2) {
                                        Logger.logError((Throwable)e2, (Plugin)CommonModiscoActivator.getDefault());
                                    }
                                }
                                if (targetReader != null) {
                                    try {
                                        targetReader.close();
                                    }
                                    catch (IOException e3) {
                                        Logger.logError((Throwable)e3, (Plugin)CommonModiscoActivator.getDefault());
                                    }
                                }
                                break block33;
                            }
                            catch (IOException e) {
                                try {
                                    result = false;
                                    break block33;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (sourceReader != null) {
                                        try {
                                            sourceReader.close();
                                        }
                                        catch (IOException e4) {
                                            Logger.logError((Throwable)e4, (Plugin)CommonModiscoActivator.getDefault());
                                        }
                                    }
                                    if (targetReader != null) {
                                        try {
                                            targetReader.close();
                                        }
                                        catch (IOException e5) {
                                            Logger.logError((Throwable)e5, (Plugin)CommonModiscoActivator.getDefault());
                                        }
                                    }
                                }
                            }
                            if (sourceReader == null) break block34;
                            try {
                                sourceReader.close();
                            }
                            catch (IOException e) {
                                Logger.logError((Throwable)e, (Plugin)CommonModiscoActivator.getDefault());
                            }
                        }
                        if (targetReader != null) {
                            try {
                                targetReader.close();
                            }
                            catch (IOException e) {
                                Logger.logError((Throwable)e, (Plugin)CommonModiscoActivator.getDefault());
                            }
                        }
                    }
                }
                if (result) {
                    return 0;
                }
                return -1;
            }
        };
    }

    @Deprecated
    public static final boolean compareFiles(File source, File target, Comparator<File> fileComparator) {
        boolean result;
        assert (source.isFile() && target.isFile());
        boolean bl = result = fileComparator.compare(source, target) == 0;
        if (debug && result) {
            Logger.logInfo((String)("Files " + source.getName() + " and " + target.getName() + " are equal."), (Plugin)CommonModiscoActivator.getDefault());
        }
        return result;
    }

    @Deprecated
    public static final String getFileContent(File source) {
        return FileUtils.getFileContent((File)source);
    }

    @Deprecated
    private static final boolean recursiveCompareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        File[] targetContents;
        if (debug) {
            Logger.logError((String)("comparison of " + folderSource.getName() + " and " + folderTarget.getName()), (Plugin)CommonModiscoActivator.getDefault());
        }
        boolean result = true;
        File[] sourceContents = folderSource.listFiles(filter);
        if (sourceContents.length != (targetContents = folderTarget.listFiles(filter)).length) {
            result = false;
            if (debug) {
                Logger.logError((String)("folders " + folderSource.getName() + " and " + folderTarget.getName() + " do not have the same number of children (" + sourceContents.length + ", " + targetContents.length + ")"), (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            File[] fileArray = sourceContents;
            int n = sourceContents.length;
            int n2 = 0;
            while (n2 < n) {
                boolean subResult;
                File sourceContent = fileArray[n2];
                File targetContent = FolderUtils.getCorrespondingTargetContent(sourceContent, targetContents);
                if (targetContent == null) {
                    result = false;
                    if (debug) {
                        Logger.logError((String)("There is no corresponding element in target folder for " + sourceContent.getName()), (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else if (sourceContent.isDirectory()) {
                    subResult = FolderUtils.recursiveCompareFolders(sourceContent, targetContent, filter, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        Logger.logError((String)("folders " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal."), (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else {
                    subResult = FolderUtils.compareFiles(sourceContent, targetContent, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        Logger.logError((String)("files " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal."), (Plugin)CommonModiscoActivator.getDefault());
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Deprecated
    private static final File getCorrespondingTargetContent(File sourceContent, File[] targetContents) {
        File targetContent = null;
        File[] fileArray = targetContents;
        int n = targetContents.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (sourceContent.getName().equals(temp.getName())) {
                targetContent = temp;
            }
            ++n2;
        }
        return targetContent;
    }

    @Deprecated
    public static final void copyDirectory(File srcDir, File destDir) throws IOException {
        FolderUtils.copyDirectory(srcDir, destDir, new IFilter(){

            public boolean filter(Object object) {
                return true;
            }
        });
    }

    @Deprecated
    public static final void copyDirectory(File srcDir, File destDir, IFilter filter) throws IOException {
        HashMap<File, File> src2dest = new HashMap<File, File>();
        FolderUtils.copyDirectory2(srcDir, destDir, filter, src2dest);
        for (File srcDir2 : src2dest.keySet()) {
            File destDir2 = (File)src2dest.get(srcDir2);
            if (!destDir2.exists()) {
                destDir2.mkdirs();
            }
            File[] fileArray = srcDir2.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dest;
                File src = fileArray[n2];
                if (!src.isDirectory() && filter.filter((Object)(dest = new File(String.valueOf(destDir2.getPath()) + File.separator + src.getName())))) {
                    FileUtils.copyFile((File)src, (File)dest);
                }
                ++n2;
            }
        }
    }

    @Deprecated
    private static final void copyDirectory2(File srcDir, File destDir, IFilter filter, Map<File, File> src2dest) throws IOException {
        src2dest.put(srcDir, destDir);
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dest;
            File src = fileArray[n2];
            if (src.isDirectory() && filter.filter((Object)(dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName())))) {
                FolderUtils.copyDirectory2(src, dest, filter, src2dest);
            }
            ++n2;
        }
    }

    @Deprecated
    public static void copyFolderFromBundle(String sourcePath, Bundle sourceBundle, String targetPath, IProject targetProject) throws IOException, CoreException {
        FileUtils.copyFolderFromBundle((Bundle)sourceBundle, (String)sourcePath, (IProject)targetProject, (String)targetPath);
    }

    @Deprecated
    public static final boolean copyFile(File source, File destination) {
        return FileUtils.copyFile((File)source, (File)destination);
    }

    @Deprecated
    public static final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FolderUtils.clearFolder(directory);
        if (directory.list().length == 0 && !directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    @Deprecated
    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FolderUtils.createFolder((IFolder)folder.getParent());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Deprecated
    public static final void writeFileContent(File source, String newContent) throws IOException {
        FileWriter fw = new FileWriter(source, false);
        fw.write(newContent);
        fw.close();
    }

    private static class ConfigurationManagementFilter
    implements FilenameFilter {
        private static final String FILTER_NAME = "CVS";

        private ConfigurationManagementFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = false;
            if (!name.equals(FILTER_NAME)) {
                result = true;
            }
            return result;
        }
    }
}

