/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.ui.internal.controls;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.ui.internal.MoDiscoCommonUIPlugin;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class Tooltip {
    private Shell fTip = null;
    private Label fLabel = null;

    public void installOn(Tree tree) {
        tree.setToolTipText("");
        this.addTooltip(tree);
    }

    private void addTooltip(final Tree tree) {
        Listener treeListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (Tooltip.this.fTip == null) break;
                        Tooltip.this.fTip.dispose();
                        Tooltip.this.fTip = null;
                        Tooltip.this.fLabel = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = null;
                        item = tree.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        Tooltip.this.onHover(item);
                        break;
                    }
                    default: {
                        Logger.logWarning((String)"Unhandled event", (Plugin)MoDiscoCommonUIPlugin.getDefault());
                    }
                }
            }
        };
        tree.addListener(12, treeListener);
        tree.addListener(1, treeListener);
        tree.addListener(5, treeListener);
        tree.addListener(32, treeListener);
    }

    protected String getText(TreeItem item) {
        return item.getText();
    }

    protected void onHover(TreeItem item) {
        String text = this.getText(item);
        if (text != null && text.length() > 0) {
            Display display = Display.getCurrent();
            this.createTooltip(display, text, item);
        }
    }

    protected void createTooltip(Display display, String text, TreeItem item) {
        if (this.fTip != null && !this.fTip.isDisposed()) {
            this.fTip.dispose();
        }
        this.fTip = new Shell(display.getActiveShell(), 540676);
        this.createTooltipContent(this.fTip, text, display, item);
        Point size = this.fTip.computeSize(-1, -1);
        Point pt = display.getCursorLocation();
        this.positionTooltip(item, pt, size);
        Rectangle clientArea = Display.getCurrent().getClientArea();
        if (pt.x + size.x > clientArea.width) {
            pt.x = clientArea.width - size.x;
        }
        if (pt.y + size.y > clientArea.height) {
            pt.y = clientArea.height - size.y;
        }
        this.fTip.setBounds(pt.x, pt.y, size.x, size.y);
        this.fTip.setVisible(true);
    }

    protected void createTooltipContent(Shell shell, String text, Display display, TreeItem item) {
        shell.setBackground(display.getSystemColor(29));
        FillLayout layout = new FillLayout();
        layout.marginWidth = 2;
        shell.setLayout((Layout)layout);
        this.fLabel = new Label((Composite)shell, 0);
        this.fLabel.setForeground(display.getSystemColor(28));
        this.fLabel.setBackground(display.getSystemColor(29));
        this.fLabel.setText(text);
        this.addMouseExitListener((Control)this.fLabel);
    }

    protected void positionTooltip(TreeItem item, Point pt, Point tooltipSize) {
        int verticalCursorOffset = 30;
        pt.y += 30;
    }

    protected void addMouseExitListener(final Control control) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = control.getShell();
                shell.dispose();
            }
        };
        control.addListener(7, listener);
    }
}

