/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.ui.internal.editorInputs.ResourceEditorInput;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static void openEditor(final IFile source) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FileEditorInput editorInput = new FileEditorInput(source);
                ModelUtils.openEditor((IEditorInput)editorInput);
            }
        });
    }

    public static void openEditor(final Resource model) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceEditorInput editorInput = new ResourceEditorInput(model);
                if (model.getResourceSet() == null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResources().add((Object)model);
                }
                ModelUtils.openEditor((IEditorInput)editorInput);
            }
        });
    }

    public static void scheduleEditorOpening(final IFile source, Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getResult().isOK()) {
                    ModelUtils.openEditor(source);
                }
            }
        });
    }

    public static void scheduleEditorOpening(final Resource model, Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getResult().isOK()) {
                    ModelUtils.openEditor(model);
                }
            }
        });
    }

    private static void openEditor(IEditorInput editorInput) {
        IEditorDescriptor editDesc;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart existingEditorOnResource = page.findEditor(editorInput);
        if (existingEditorOnResource != null) {
            page.closeEditor(existingEditorOnResource, true);
        }
        if ((editDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.modisco.infra.browser.editorID")) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editDesc.getId());
            }
            catch (PartInitException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

