/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.facet.core.adapters.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.core.FacetContext;
import org.eclipse.modisco.infra.facet.core.FacetContextListener;
import org.eclipse.modisco.infra.facet.core.extensions.RefreshStrategy;
import org.eclipse.modisco.infra.facet.core.internal.Activator;
import org.eclipse.modisco.infra.facet.core.internal.extensions.RefreshStrategiesRegistry;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.modisco.infra.query.core.exception.ProjectDisabledException;
import org.eclipse.modisco.util.emf.core.internal.allinstances.MetaclassInstancesAdapter;

@Deprecated
public class MetaclassInstancesAdapterWithFacet
extends MetaclassInstancesAdapter
implements FacetContextListener {
    private final FacetContext facetContext;

    protected MetaclassInstancesAdapterWithFacet(Resource resource, FacetContext facetContext) {
        super(resource, false);
        this.facetContext = facetContext;
        this.facetContext.addListener(this);
        this.clearCache();
    }

    protected List<EClass> getEClasses(EObject element) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        eClasses.add(element.eClass());
        eClasses.addAll(this.facetContext.getFacets(element));
        return eClasses;
    }

    @Override
    public void facetAdded(Facet facet) {
        TreeIterator allContents = this.getResource().getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            try {
                if (!this.facetContext.isInstance(eObject, facet)) continue;
                this.associateToEClass(eObject, (EClass)facet);
                this.associateToType(eObject, (EClass)facet);
            }
            catch (ProjectDisabledException projectDisabledException) {
            }
            catch (ModelQueryException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        this.notifyModelChanged(null);
    }

    @Override
    public void facetsCleared() {
        this.removeFacets(this.getInstancesByEClass().keySet());
        this.removeFacets(this.getInstancesByType().keySet());
        this.notifyModelChanged(null);
    }

    private void removeFacets(Set<EClass> eClasses) {
        Iterator<EClass> eClassesIterator = eClasses.iterator();
        while (eClassesIterator.hasNext()) {
            EClass eClass = eClassesIterator.next();
            if (!(eClass instanceof Facet)) continue;
            eClassesIterator.remove();
        }
    }

    public FacetContext getFacetContext() {
        return this.facetContext;
    }

    protected void handleChanged(Notification msg) {
        super.handleChanged(msg);
        Object notifier = msg.getNotifier();
        int eventType = msg.getEventType();
        if (notifier instanceof EObject) {
            switch (eventType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    EObject eObject = (EObject)notifier;
                    this.elementChanged(eObject, msg);
                }
            }
        }
    }

    private void elementChanged(EObject eObject, Notification msg) {
        HashSet<EObject> impactedElements = new HashSet<EObject>();
        List<RefreshStrategy> refreshStrategies = RefreshStrategiesRegistry.getInstance().getRefreshStrategies(this.facetContext.getAppliedFacets());
        for (RefreshStrategy refreshStrategy : refreshStrategies) {
            Collection<EObject> elementsImpactedFromChange = refreshStrategy.findElementsImpactedFromChange(eObject, msg);
            if (elementsImpactedFromChange == null) continue;
            impactedElements.addAll(elementsImpactedFromChange);
        }
        for (EObject impactedElement : impactedElements) {
            this.removeModelElement(impactedElement, false);
            this.addModelElement(impactedElement, false);
        }
        if (!impactedElements.contains(eObject)) {
            this.removeModelElement(eObject, false);
            this.addModelElement(eObject, false);
        }
    }
}

