/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.ejbjar.discoverer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.actions.AbstractDeploymentDescriptorDiscoverer;
import org.eclipse.modisco.jee.ejbjar.EjbJar11.util.EjbJar11ResourceFactoryImpl;
import org.eclipse.modisco.jee.ejbjar.EjbJar20.util.EjbJar20ResourceFactoryImpl;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.util.EjbJar21ResourceFactoryImpl;
import org.eclipse.modisco.jee.ejbjar.EjbJar30.util.EjbJar30ResourceFactoryImpl;
import org.eclipse.modisco.jee.ejbjar.EjbJar31.util.EjbJar31ResourceFactoryImpl;
import org.eclipse.modisco.jee.ejbjar.discoverer.EjbJarActivator;

public class EjbJarDiscoverer2
extends AbstractDeploymentDescriptorDiscoverer<IFile> {
    private Resource.Factory modiscoResourceFactory;
    public static final String ROOT_NAME = "ejb-jar";
    public static final String DTD_URL = "http://java.sun.com/j2ee/dtds/";
    public static final String ID = "org.eclipse.modisco.jee.ejbjar.discoverer";

    public boolean isApplicableTo(IFile source) {
        return EjbJarDiscoverer2.isAnIFileWithExtension((Object)source, (String)"xml");
    }

    public void discoverElement(File file, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createFileURI((String)file.getPath().concat("_ejbjar.xmi")));
        URI sourceURI = URI.createFileURI((String)file.getPath().toString());
        this.initializeResourceFactory(file);
        this.discoverResourceInternal(sourceURI);
        monitor.setTaskName(Messages.AbstractModelDiscoverer_savingModel);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error saving discovery result model", (Plugin)EjbJarActivator.getDefault());
            }
        }
    }

    private void initializeResourceFactory(Object source) throws DiscoveryException {
        String version = EjbJarDiscoverer2.getDescXmlVersion((Plugin)EjbJarActivator.getDefault(), (Object)source, (String)ROOT_NAME, (String)DTD_URL);
        if (version.equalsIgnoreCase("1.1")) {
            this.setModiscoResourceFactory((Resource.Factory)new EjbJar11ResourceFactoryImpl());
        } else if (version.equalsIgnoreCase("2.0")) {
            this.setModiscoResourceFactory((Resource.Factory)new EjbJar20ResourceFactoryImpl());
        } else if (version.equalsIgnoreCase("2.1")) {
            this.setModiscoResourceFactory((Resource.Factory)new EjbJar21ResourceFactoryImpl());
        } else if (version.equalsIgnoreCase("3.0")) {
            this.setModiscoResourceFactory((Resource.Factory)new EjbJar30ResourceFactoryImpl());
        } else if (version.equalsIgnoreCase("3.1")) {
            this.setModiscoResourceFactory((Resource.Factory)new EjbJar31ResourceFactoryImpl());
        } else {
            throw new DiscoveryException("No known version of ejb-jar.xml detected; aborting the process");
        }
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)source.getFullPath().toString().concat("_ejbjar.xmi"), (boolean)true));
        this.initializeResourceFactory(source);
        URI sourceURI = URI.createPlatformResourceURI((String)source.getFullPath().toString(), (boolean)true);
        this.discoverResourceInternal(sourceURI);
    }

    private void discoverResourceInternal(URI sourceURI) throws DiscoveryException {
        try {
            Resource resource = this.getModiscoResourceFactory().createResource(sourceURI);
            this.getResourceSet().getResources().add((Object)resource);
            resource.load(null);
            this.setTargetModel(resource);
            Map unknowFeature = ((XMLResource)resource).getEObjectToExtensionMap();
            for (AnyType anyType : unknowFeature.values()) {
                Logger.logWarning((String)("Unknown feature detected:" + anyType.toString()), (Plugin)EjbJarActivator.getDefault());
            }
        }
        catch (IOException e) {
            throw new DiscoveryException("An error occured during model discovery from: " + sourceURI.toString(), (Throwable)e);
        }
    }

    public void discoverResource(URI sourceURI) throws DiscoveryException {
        this.initializeResourceFactory(sourceURI);
        this.discoverResourceInternal(sourceURI);
    }

    protected void setModiscoResourceFactory(Resource.Factory modiscoResourceFactory) {
        this.modiscoResourceFactory = modiscoResourceFactory;
    }

    protected Resource.Factory getModiscoResourceFactory() {
        return this.modiscoResourceFactory;
    }

    protected void saveTargetModel() throws IOException {
        Resource xmlResource = this.getTargetModel();
        Resource xmiResource = this.createTargetModel();
        xmiResource.getContents().addAll((Collection)xmlResource.getContents());
        xmlResource.getResourceSet().getResources().remove((Object)xmlResource);
        super.saveTargetModel();
    }
}

