/**
 * Copyright (c) 2010, 2026 Mia-Software and others.
 *    All rights reserved. This program and the accompanying materials
 *    are made available under the terms of the Eclipse Public License v2.0
 *    which accompanies this distribution, and is available at
 *    http://www.eclipse.org/legal/epl-v20.html
 *    
 *    Contributors:
 *    
 *    	   Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.modisco.jee.ejbjar.EjbJar21.impl;

import java.lang.String;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.modisco.jee.ejbjar.EjbJar21.DescriptionType;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.EjbJar21Package;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.EnvEntryType;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.EnvEntryTypeValuesType;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.JndiNameType;
import org.eclipse.modisco.jee.ejbjar.EjbJar21.XsdStringType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Env Entry Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.modisco.jee.ejbjar.EjbJar21.impl.EnvEntryTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.ejbjar.EjbJar21.impl.EnvEntryTypeImpl#getEnvEntryName <em>Env Entry Name</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.ejbjar.EjbJar21.impl.EnvEntryTypeImpl#getEnvEntryType <em>Env Entry Type</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.ejbjar.EjbJar21.impl.EnvEntryTypeImpl#getEnvEntryValue <em>Env Entry Value</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.ejbjar.EjbJar21.impl.EnvEntryTypeImpl#getId <em>Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EnvEntryTypeImpl extends EObjectImpl implements EnvEntryType {
	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected EList<DescriptionType> description;

	/**
	 * The cached value of the '{@link #getEnvEntryName() <em>Env Entry Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnvEntryName()
	 * @generated
	 * @ordered
	 */
	protected JndiNameType envEntryName;

	/**
	 * The cached value of the '{@link #getEnvEntryType() <em>Env Entry Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnvEntryType()
	 * @generated
	 * @ordered
	 */
	protected EnvEntryTypeValuesType envEntryType;

	/**
	 * The cached value of the '{@link #getEnvEntryValue() <em>Env Entry Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnvEntryValue()
	 * @generated
	 * @ordered
	 */
	protected XsdStringType envEntryValue;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnvEntryTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return EjbJar21Package.Literals.ENV_ENTRY_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DescriptionType> getDescription() {
		if (description == null) {
			description = new EObjectContainmentEList<DescriptionType>(DescriptionType.class, this, EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION);
		}
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JndiNameType getEnvEntryName() {
		return envEntryName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEnvEntryName(JndiNameType newEnvEntryName, NotificationChain msgs) {
		JndiNameType oldEnvEntryName = envEntryName;
		envEntryName = newEnvEntryName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME, oldEnvEntryName, newEnvEntryName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnvEntryName(JndiNameType newEnvEntryName) {
		if (newEnvEntryName != envEntryName) {
			NotificationChain msgs = null;
			if (envEntryName != null)
				msgs = ((InternalEObject)envEntryName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME, null, msgs);
			if (newEnvEntryName != null)
				msgs = ((InternalEObject)newEnvEntryName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME, null, msgs);
			msgs = basicSetEnvEntryName(newEnvEntryName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME, newEnvEntryName, newEnvEntryName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnvEntryTypeValuesType getEnvEntryType() {
		return envEntryType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEnvEntryType(EnvEntryTypeValuesType newEnvEntryType, NotificationChain msgs) {
		EnvEntryTypeValuesType oldEnvEntryType = envEntryType;
		envEntryType = newEnvEntryType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE, oldEnvEntryType, newEnvEntryType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnvEntryType(EnvEntryTypeValuesType newEnvEntryType) {
		if (newEnvEntryType != envEntryType) {
			NotificationChain msgs = null;
			if (envEntryType != null)
				msgs = ((InternalEObject)envEntryType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE, null, msgs);
			if (newEnvEntryType != null)
				msgs = ((InternalEObject)newEnvEntryType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE, null, msgs);
			msgs = basicSetEnvEntryType(newEnvEntryType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE, newEnvEntryType, newEnvEntryType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XsdStringType getEnvEntryValue() {
		return envEntryValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEnvEntryValue(XsdStringType newEnvEntryValue, NotificationChain msgs) {
		XsdStringType oldEnvEntryValue = envEntryValue;
		envEntryValue = newEnvEntryValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE, oldEnvEntryValue, newEnvEntryValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnvEntryValue(XsdStringType newEnvEntryValue) {
		if (newEnvEntryValue != envEntryValue) {
			NotificationChain msgs = null;
			if (envEntryValue != null)
				msgs = ((InternalEObject)envEntryValue).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE, null, msgs);
			if (newEnvEntryValue != null)
				msgs = ((InternalEObject)newEnvEntryValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE, null, msgs);
			msgs = basicSetEnvEntryValue(newEnvEntryValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE, newEnvEntryValue, newEnvEntryValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EjbJar21Package.ENV_ENTRY_TYPE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION:
				return ((InternalEList<?>)getDescription()).basicRemove(otherEnd, msgs);
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME:
				return basicSetEnvEntryName(null, msgs);
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE:
				return basicSetEnvEntryType(null, msgs);
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE:
				return basicSetEnvEntryValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION:
				return getDescription();
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME:
				return getEnvEntryName();
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE:
				return getEnvEntryType();
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE:
				return getEnvEntryValue();
			case EjbJar21Package.ENV_ENTRY_TYPE__ID:
				return getId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION:
				getDescription().clear();
				getDescription().addAll((Collection<? extends DescriptionType>)newValue);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME:
				setEnvEntryName((JndiNameType)newValue);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE:
				setEnvEntryType((EnvEntryTypeValuesType)newValue);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE:
				setEnvEntryValue((XsdStringType)newValue);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ID:
				setId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION:
				getDescription().clear();
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME:
				setEnvEntryName((JndiNameType)null);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE:
				setEnvEntryType((EnvEntryTypeValuesType)null);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE:
				setEnvEntryValue((XsdStringType)null);
				return;
			case EjbJar21Package.ENV_ENTRY_TYPE__ID:
				setId(ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case EjbJar21Package.ENV_ENTRY_TYPE__DESCRIPTION:
				return description != null && !description.isEmpty();
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_NAME:
				return envEntryName != null;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_TYPE:
				return envEntryType != null;
			case EjbJar21Package.ENV_ENTRY_TYPE__ENV_ENTRY_VALUE:
				return envEntryValue != null;
			case EjbJar21Package.ENV_ENTRY_TYPE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: "); //$NON-NLS-1$
		result.append(id);
		result.append(')');
		return result.toString();
	}

} //EnvEntryTypeImpl
