/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.jee.actions.Messages;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractDeploymentDescriptorDiscoverer<T>
extends AbstractModelDiscoverer<T> {
    public static String getDescXmlVersion(Plugin plugin, Object source, String rootName, String dtdUrl) {
        String version1 = AbstractDeploymentDescriptorDiscoverer.getDescXmlVersion_step1(plugin, source, rootName);
        if (version1 != null) {
            return version1;
        }
        String version2 = AbstractDeploymentDescriptorDiscoverer.getDescXmlVersion_step2(plugin, source, rootName, dtdUrl);
        if (version2 != null) {
            return version2;
        }
        return "";
    }

    private static String getDescXmlVersion_step1(Plugin plugin, Object source, String rootName) {
        Reader reader = null;
        try {
            String systemId;
            String http;
            reader = AbstractDeploymentDescriptorDiscoverer.openReader(source);
            BufferedReader buffReader = new BufferedReader(reader);
            String line = buffReader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (line != null) {
                if (line.contains("<!DOCTYPE")) {
                    buffer.append(line);
                    if (line.contains(">")) break;
                    line = buffReader.readLine();
                    while (line != null) {
                        buffer.append(line);
                        if (line.contains(">")) break;
                        line = buffReader.readLine();
                    }
                }
                line = buffReader.readLine();
            }
            if (buffer.length() > 0 && buffer.indexOf(http = "http://java.sun.com") > 0 && (systemId = buffer.substring(buffer.indexOf(http))).indexOf(".dtd") > 0) {
                systemId = systemId.substring(0, systemId.indexOf(".dtd"));
                String string = systemId.substring(systemId.indexOf(rootName) + rootName.length() + 1, systemId.length()).replace("_", ".");
                return string;
            }
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)e.getMessage(), (Plugin)plugin);
        }
        catch (IOException e) {
            Logger.logError((String)e.getMessage(), (Plugin)plugin);
        }
        finally {
            AbstractDeploymentDescriptorDiscoverer.closeReader(reader);
        }
        return null;
    }

    private static String getDescXmlVersion_step2(Plugin plugin, Object source, String rootName, String dtdUrl) {
        block18: {
            String extension = ".xsd";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Reader reader = null;
            try {
                reader = AbstractDeploymentDescriptorDiscoverer.openReader(source);
                InputSource inputSource = new InputSource(reader);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(inputSource);
                doc.getDocumentElement().normalize();
                if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase(rootName)) {
                    return "0";
                }
                if (!doc.getDocumentElement().getAttribute("version").toString().equalsIgnoreCase("")) {
                    String string = doc.getDocumentElement().getAttribute("version").toString();
                    return string;
                }
                if (!doc.getDocumentElement().getAttribute("xsi:schemaLocation").toString().equalsIgnoreCase("")) {
                    String schemaLocation = doc.getDocumentElement().getAttribute("xsi:schemaLocation");
                    if (schemaLocation.contains(rootName)) {
                        String string = ((String)schemaLocation.subSequence(schemaLocation.indexOf(rootName) + rootName.length() + 1, schemaLocation.length() - extension.length())).replace("_", ".");
                        return string;
                    }
                    break block18;
                }
                if (doc.getDoctype() != null) {
                    String systemId = doc.getDoctype().getSystemId();
                    String string = systemId.substring(systemId.indexOf(rootName) + rootName.length() + 1, systemId.length() - extension.length()).replace("_", ".");
                    return string;
                }
                String string = AbstractDeploymentDescriptorDiscoverer.getDoctypeVersion(plugin, source, rootName, dtdUrl);
                return string;
            }
            catch (ParserConfigurationException e) {
                Logger.logError((String)e.getMessage(), (Plugin)plugin);
            }
            catch (IOException e) {
                Logger.logError((String)e.getMessage(), (Plugin)plugin);
            }
            catch (SAXException e) {
                Logger.logError((String)e.getMessage(), (Plugin)plugin);
            }
            finally {
                AbstractDeploymentDescriptorDiscoverer.closeReader(reader);
            }
        }
        return null;
    }

    public static String getDoctypeVersion(Plugin plugin, Object source, String rootName, String baseUrl) {
        String version = "";
        String docType = "DOCTYPE";
        String dtdFileExtension = ".dtd";
        int dtdDeclarationSize = 5;
        Reader reader = null;
        try {
            try {
                String line;
                reader = AbstractDeploymentDescriptorDiscoverer.openReader(source);
                BufferedReader br = new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    if (!line.contains(docType)) continue;
                    Object bigLine = line;
                    int i = 0;
                    while (i < 5) {
                        bigLine = (String)bigLine + br.readLine();
                        ++i;
                    }
                    if (!((String)(bigLine = ((String)bigLine).replaceAll("\\s+", ""))).contains(baseUrl)) continue;
                    String subSq = (String)((String)bigLine).subSequence(((String)bigLine).indexOf(baseUrl), ((String)bigLine).length());
                    version = subSq.substring(subSq.indexOf(rootName) + rootName.length() + 1, subSq.indexOf(rootName) + rootName.length() + dtdFileExtension.length()).replace("_", ".");
                    break;
                }
            }
            catch (Exception e) {
                Logger.logWarning((String)(Messages.DeployementDescriptorDiscoverer_1 + e.toString()), (Plugin)plugin);
                AbstractDeploymentDescriptorDiscoverer.closeReader(reader);
            }
        }
        finally {
            AbstractDeploymentDescriptorDiscoverer.closeReader(reader);
        }
        return version;
    }

    private static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Reader openReader(Object source) throws IOException {
        if (source instanceof URI) {
            InputStream inputStream = URIConverter.INSTANCE.createInputStream((URI)source);
            return new InputStreamReader(inputStream);
        }
        File file = null;
        file = source instanceof IFile && ((IFile)source).exists() ? new File(((IFile)source).getLocation().toString()) : (File)source;
        return new FileReader(file);
    }
}

