/**
 * Copyright (c) 2009, 2026 Hatha Systems, and Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.modisco.omg.kdm.build.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.modisco.omg.kdm.build.util.BuildAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BuildItemProviderAdapterFactory extends BuildAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BuildItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildResourceItemProvider buildResourceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildResourceAdapter() {
		if (buildResourceItemProvider == null) {
			buildResourceItemProvider = new BuildResourceItemProvider(this);
		}

		return buildResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildDescriptionItemProvider buildDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildDescriptionAdapter() {
		if (buildDescriptionItemProvider == null) {
			buildDescriptionItemProvider = new BuildDescriptionItemProvider(this);
		}

		return buildDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.SymbolicLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SymbolicLinkItemProvider symbolicLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.SymbolicLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSymbolicLinkAdapter() {
		if (symbolicLinkItemProvider == null) {
			symbolicLinkItemProvider = new SymbolicLinkItemProvider(this);
		}

		return symbolicLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.LinksTo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LinksToItemProvider linksToItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.LinksTo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinksToAdapter() {
		if (linksToItemProvider == null) {
			linksToItemProvider = new LinksToItemProvider(this);
		}

		return linksToItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.Consumes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConsumesItemProvider consumesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.Consumes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConsumesAdapter() {
		if (consumesItemProvider == null) {
			consumesItemProvider = new ConsumesItemProvider(this);
		}

		return consumesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildModelItemProvider buildModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildModelAdapter() {
		if (buildModelItemProvider == null) {
			buildModelItemProvider = new BuildModelItemProvider(this);
		}

		return buildModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildComponentItemProvider buildComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildComponentAdapter() {
		if (buildComponentItemProvider == null) {
			buildComponentItemProvider = new BuildComponentItemProvider(this);
		}

		return buildComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.Supplier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SupplierItemProvider supplierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.Supplier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSupplierAdapter() {
		if (supplierItemProvider == null) {
			supplierItemProvider = new SupplierItemProvider(this);
		}

		return supplierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.Tool} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolItemProvider toolItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.Tool}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createToolAdapter() {
		if (toolItemProvider == null) {
			toolItemProvider = new ToolItemProvider(this);
		}

		return toolItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildElementItemProvider buildElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildElementAdapter() {
		if (buildElementItemProvider == null) {
			buildElementItemProvider = new BuildElementItemProvider(this);
		}

		return buildElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildRelationship} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildRelationshipItemProvider buildRelationshipItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildRelationship}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildRelationshipAdapter() {
		if (buildRelationshipItemProvider == null) {
			buildRelationshipItemProvider = new BuildRelationshipItemProvider(this);
		}

		return buildRelationshipItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.SuppliedBy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuppliedByItemProvider suppliedByItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.SuppliedBy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuppliedByAdapter() {
		if (suppliedByItemProvider == null) {
			suppliedByItemProvider = new SuppliedByItemProvider(this);
		}

		return suppliedByItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.Library} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LibraryItemProvider libraryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.Library}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLibraryAdapter() {
		if (libraryItemProvider == null) {
			libraryItemProvider = new LibraryItemProvider(this);
		}

		return libraryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildStepItemProvider buildStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildStepAdapter() {
		if (buildStepItemProvider == null) {
			buildStepItemProvider = new BuildStepItemProvider(this);
		}

		return buildStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.Produces} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProducesItemProvider producesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.Produces}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProducesAdapter() {
		if (producesItemProvider == null) {
			producesItemProvider = new ProducesItemProvider(this);
		}

		return producesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.SupportedBy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SupportedByItemProvider supportedByItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.SupportedBy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSupportedByAdapter() {
		if (supportedByItemProvider == null) {
			supportedByItemProvider = new SupportedByItemProvider(this);
		}

		return supportedByItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.BuildProduct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildProductItemProvider buildProductItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.BuildProduct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildProductAdapter() {
		if (buildProductItemProvider == null) {
			buildProductItemProvider = new BuildProductItemProvider(this);
		}

		return buildProductItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.modisco.omg.kdm.build.DescribedBy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescribedByItemProvider describedByItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.modisco.omg.kdm.build.DescribedBy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDescribedByAdapter() {
		if (describedByItemProvider == null) {
			describedByItemProvider = new DescribedByItemProvider(this);
		}

		return describedByItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (buildResourceItemProvider != null) buildResourceItemProvider.dispose();
		if (buildDescriptionItemProvider != null) buildDescriptionItemProvider.dispose();
		if (symbolicLinkItemProvider != null) symbolicLinkItemProvider.dispose();
		if (linksToItemProvider != null) linksToItemProvider.dispose();
		if (consumesItemProvider != null) consumesItemProvider.dispose();
		if (buildModelItemProvider != null) buildModelItemProvider.dispose();
		if (buildComponentItemProvider != null) buildComponentItemProvider.dispose();
		if (supplierItemProvider != null) supplierItemProvider.dispose();
		if (toolItemProvider != null) toolItemProvider.dispose();
		if (buildElementItemProvider != null) buildElementItemProvider.dispose();
		if (buildRelationshipItemProvider != null) buildRelationshipItemProvider.dispose();
		if (suppliedByItemProvider != null) suppliedByItemProvider.dispose();
		if (libraryItemProvider != null) libraryItemProvider.dispose();
		if (buildStepItemProvider != null) buildStepItemProvider.dispose();
		if (producesItemProvider != null) producesItemProvider.dispose();
		if (supportedByItemProvider != null) supportedByItemProvider.dispose();
		if (buildProductItemProvider != null) buildProductItemProvider.dispose();
		if (describedByItemProvider != null) describedByItemProvider.dispose();
	}

}
