/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.core.internal.defaultengine;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.workflow.core.WorkflowModel;
import org.eclipse.modisco.workflow.core.internal.Activator;
import org.eclipse.modisco.workflow.core.internal.Messages;
import org.eclipse.modisco.workflow.core.internal.defaultengine.Utils;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowController;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowModelImpl;
import org.eclipse.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.modisco.workflow.modiscoworkflow.Workflow;

public class WorkflowControllerImpl
implements WorkflowController {
    @Override
    public String validate(WorkflowModel workflowModel) {
        String message = null;
        String unknownLaunch = WorkflowControllerImpl.verifyExistence(workflowModel.getAllElements());
        if (unknownLaunch != null) {
            message = String.valueOf(Messages.WorkflowControllerImpl_launchConfigurationNotFound) + unknownLaunch;
        }
        if (this.verifyLoops(workflowModel.getAllElements(), workflowModel.getName())) {
            message = Messages.WorkflowControllerImpl_recursionError;
        }
        return message;
    }

    private static String verifyExistence(List<Element> allElements) {
        String unknownLaunch = null;
        for (Element element : allElements) {
            ILaunchConfiguration launch = Utils.getLaunchConfigurationFromName(element.getName());
            if (launch != null) continue;
            unknownLaunch = element.getName();
            break;
        }
        return unknownLaunch;
    }

    private boolean verifyLoops(List<Element> elements, String name) {
        boolean loop = false;
        for (Element element : elements) {
            if (!(element instanceof Workflow)) continue;
            if (element.getName().equals(name)) {
                loop = true;
                break;
            }
            WorkflowModelImpl workflowModel = new WorkflowModelImpl();
            ILaunchConfiguration launch = Utils.getLaunchConfigurationFromName(element.getName());
            if (launch == null) continue;
            workflowModel.initialize(launch);
            loop = this.verifyLoops(workflowModel.getAllElements(), name);
        }
        return loop;
    }

    @Override
    public boolean hasPotentialRecursion(String rootConfigName, ILaunchConfiguration launch) {
        boolean result = false;
        if (launch.getName().equals(rootConfigName)) {
            result = true;
        } else {
            try {
                String type = launch.getType().getIdentifier();
                if (type.equals("org.eclipse.modisco.workflow.launchType")) {
                    WorkflowModelImpl workflowModel = new WorkflowModelImpl();
                    workflowModel.initialize(launch);
                    result = this.verifyLoops(workflowModel.getAllElements(), rootConfigName);
                }
            }
            catch (CoreException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

