/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitionOperation;
import org.eclipse.swt.widgets.Shell;

public class SynchronizationOperation
extends ProductDefinitionOperation {
    public SynchronizationOperation(IProduct product, Shell shell, IProject project) {
        super(product, SynchronizationOperation.getPluginId(product), SynchronizationOperation.getProductId(product), product.getApplication(), shell, project);
    }

    private static String getProductId(IProduct product) {
        String full = product.getProductId();
        int index = full.lastIndexOf(46);
        return index != -1 ? full.substring(index + 1) : full;
    }

    private static String getPluginId(IProduct product) {
        String full = product.getProductId();
        int index = full.lastIndexOf(46);
        return index != -1 ? full.substring(0, index) : full;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IPluginModelBase model = PluginRegistry.findModel((String)this.fPluginId);
        if (model == null) {
            String message = PDEUIMessages.SynchronizationOperation_noDefiningPlugin;
            throw new InvocationTargetException(this.createCoreException(message));
        }
        if (model.getUnderlyingResource() == null) {
            String id = model.getPluginBase().getId();
            String message = PDEUIMessages.SynchronizationOperation_externalPlugin;
            throw new InvocationTargetException(this.createCoreException(NLS.bind((String)message, (Object)id)));
        }
        super.run(monitor);
    }

    private CoreException createCoreException(String message) {
        return new CoreException(Status.error((String)message));
    }
}

