/*******************************************************************************
 * Copyright (c) 2016 Zend Technologies and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Zend Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.model.IDebugTarget;
import org.w3c.dom.Node;

/**
 * DBGp variable for handling stack variables.
 * 
 * @author Bartlomiej Laczkowski
 */
public class DBGpStackVariable extends DBGpVariable {

	/**
	 * Creates new DBGp stack variable.
	 * 
	 * @param target
	 * @param descriptor
	 * @param stackLevel
	 * @param facets
	 */
	public DBGpStackVariable(IDebugTarget target, Node descriptor, int stackLevel, Facet... facets) {
		super(target, descriptor, stackLevel, facets);
	}

	@Override
	protected Kind getKind() {
		return Kind.STACK;
	}

	@Override
	protected Node getNode(int page) {
		DBGpTarget target = (DBGpTarget) getDebugTarget();
		return target.getProperty(getFullName(), String.valueOf(getStackLevel()), page);
	}

}
