/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ArrayIterable;
import org.eclipse.qvtd.runtime.evaluation.AbstractModelsManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.InvalidEvaluationException;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.qvtruntimelibrary.Extent;
import org.eclipse.qvtd.runtime.qvtruntimelibrary.QVTruntimeLibraryFactory;

public class RuntimeModelsManager
extends AbstractModelsManager {
    protected final @NonNull Model @NonNull [] models;

    protected RuntimeModelsManager(int models) {
        this.models = new Model[models];
    }

    public @NonNull Model @NonNull [] getModels() {
        return this.models;
    }

    @Override
    public @NonNull Model getTypedModelInstance(@NonNull String modelName) {
        Model[] modelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Model model = modelArray[n2];
            if (modelName.equals(model.getName())) {
                return model;
            }
            ++n2;
        }
        throw new IllegalStateException("Unknown model name '" + modelName + "'");
    }

    public int getTypedModelIndex(@NonNull String targetModelName) {
        int index = 0;
        Model[] modelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Model model = modelArray[n2];
            if (targetModelName.equals(model.getName())) {
                return index;
            }
            ++index;
            ++n2;
        }
        throw new IllegalStateException("Unknown model name '" + targetModelName + "'");
    }

    public @NonNull Iterable<@NonNull TypedModelInstance> getTypedModelInstances() {
        return new ArrayIterable((Object[])this.models);
    }

    public void initTypedModelInstance(int i, @NonNull Model model) {
        this.models[i] = model;
    }

    public @NonNull Object throwInvalidEvaluationException(@NonNull String message, Object ... bindings) {
        throw new InvalidEvaluationException(message, bindings);
    }

    protected @NonNull String toDebugString(@Nullable Object object) {
        return AbstractObjectManager.toDebugString(object);
    }

    public static class Model
    extends AbstractTypedModelInstance {
        public Model(@NonNull RuntimeModelsManager modelsManager, @NonNull String name) {
            super(modelsManager, name);
        }

        @Override
        protected void addExtent() {
            Extent extent = QVTruntimeLibraryFactory.eINSTANCE.createExtent();
            EList<Object> elements = extent.getElements();
            assert (elements != null);
            this.addExtent(extent, (List<Object>)elements);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        protected @Nullable Iterable<@NonNull EObject> getExtentElements(@NonNull EObject rootObject) {
            if (rootObject instanceof Extent) {
                @NonNull Iterable elements = (Iterable)((Extent)rootObject).getElements();
                return elements;
            }
            return null;
        }

        public static class Incremental
        extends Model {
            public Incremental(@NonNull RuntimeModelsManager transformer, @NonNull String name) {
                super(transformer, name);
            }

            @Override
            public void remove(@NonNull EObject eObject) {
                super.remove(eObject);
                this.rootObjects.remove(eObject);
                if (this.classIndex2connection != null) {
                    this.getEClassAnalysis(eObject).unpropagate(eObject);
                }
            }
        }
    }
}

