/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import java.util.Collection;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.ExclusionSearch;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Handle;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IRootFigure;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.gef.core.AbstractEditPartViewer;
import org.eclipse.wb.internal.gef.graphical.EditEventManager;
import org.eclipse.wb.internal.gef.graphical.RootEditPart;

public class GraphicalViewer
extends AbstractEditPartViewer
implements org.eclipse.gef.GraphicalViewer {
    protected final FigureCanvas m_canvas;
    private final RootEditPart m_rootEditPart;
    private EditEventManager m_eventManager;

    public GraphicalViewer(Composite parent) {
        this(parent, 768);
    }

    public GraphicalViewer(Composite parent, int style) {
        this(new FigureCanvas(parent, style){

            @Override
            protected void setDefaultEventManager() {
            }
        });
    }

    protected GraphicalViewer(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_rootEditPart = new RootEditPart(this.getRootFigure());
        this.m_rootEditPart.setViewer(this);
        this.m_rootEditPart.activate();
        this.setRootEditPart(this.m_rootEditPart);
    }

    public FigureCanvas getControl() {
        return this.m_canvas;
    }

    @Override
    public int getHOffset() {
        return this.m_canvas.getViewport().getHorizontalRangeModel().getValue();
    }

    @Override
    public int getVOffset() {
        return this.m_canvas.getViewport().getVerticalRangeModel().getValue();
    }

    public RootEditPart getRootEditPart() {
        return this.m_rootEditPart;
    }

    public final IRootFigure getRootFigure() {
        return this.getRootFigureInternal();
    }

    protected final RootFigure getRootFigureInternal() {
        return this.m_canvas.getRootFigure();
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.m_eventManager = new EditEventManager(this.m_canvas, domain, this);
        this.m_canvas.getLightweightSystem().setEventDispatcher((EventDispatcher)this.m_eventManager);
    }

    public void setCursor(Cursor cursor) {
        this.m_eventManager.setOverrideCursor(cursor);
    }

    public EditPart findObjectAtExcluding(Point location, Collection exclude, EditPartViewer.Conditional conditional) {
        EditPart editPart = this.findObjectAtExcluding(location, exclude, conditional, "Menu Primary Layer");
        if (editPart == null) {
            editPart = this.findObjectAtExcluding(location, exclude, conditional, "Primary Layer");
        }
        return editPart;
    }

    @Override
    public EditPart findObjectAtExcluding(Point location, Collection<IFigure> exclude, final EditPartViewer.Conditional conditional, final String layer) {
        class ConditionalTreeSearch
        extends ExclusionSearch {
            ConditionalTreeSearch(Collection<IFigure> coll) {
                super(coll);
            }

            public boolean accept(IFigure figure) {
                EditPart editpart = null;
                while (editpart == null && figure != null) {
                    editpart = (EditPart)this.getVisualPartMap().get(figure);
                    figure = figure.getParent();
                }
                return editpart != null && (conditional == null || conditional.evaluate(editpart));
            }

            public boolean prune(IFigure figure) {
                if (figure instanceof Layer) {
                    Layer layerFigure = (Layer)figure;
                    return !layer.equals(layerFigure.getName());
                }
                return super.prune(figure);
            }
        }
        IFigure figure = this.m_canvas.getLightweightSystem().getRootFigure().findFigureAt(location.x, location.y, (TreeSearch)new ConditionalTreeSearch(exclude));
        EditPart editPart = null;
        while (editPart == null && figure != null) {
            editPart = (EditPart)this.getVisualPartMap().get(figure);
            figure = figure.getParent();
        }
        return editPart;
    }

    public Handle findHandleAt(Point p) {
        Handle target = this.findTargetHandle("Menu Handle Layer static", p);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Menu Handle Layer", p);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer Static", p);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer", p);
        if (target != null) {
            return target;
        }
        return null;
    }

    private Handle findTargetHandle(final String layer, Point p) {
        return (Handle)this.m_canvas.getLightweightSystem().getRootFigure().findFigureAt(p.x, p.y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return figure instanceof Handle;
            }

            public boolean prune(IFigure figure) {
                Layer layerFigure;
                return figure instanceof Layer && !layer.equals((layerFigure = (Layer)figure).getName());
            }
        });
    }
}

