/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class VmResourceIdMap<T> {
    private final Map<String, T> scriptNameMap = new HashMap<String, T>();
    private final Map<Object, T> scriptIdMap = new HashMap<Object, T>();

    public T get(VmResourceId resourceId) {
        Object result;
        Object scriptId = resourceId.getId();
        if (scriptId != null && (result = BasicUtil.getSafe(this.scriptIdMap, (Object)scriptId)) != null) {
            return (T)result;
        }
        return this.getByName(resourceId.getName());
    }

    public T getByName(String scriptName) {
        Object result;
        if (scriptName != null && (result = BasicUtil.getSafe(this.scriptNameMap, (Object)scriptName)) != null) {
            return (T)result;
        }
        return null;
    }

    public void put(VmResourceId resourceId, T data) {
        T conflict;
        T conflict2;
        Object scriptId = resourceId.getId();
        if (scriptId != null && (conflict2 = this.scriptIdMap.put(scriptId, data)) != null) {
            throw new RuntimeException();
        }
        String scriptName = resourceId.getName();
        if (scriptName != null && (conflict = this.scriptNameMap.put(scriptName, data)) != null) {
            throw new RuntimeException();
        }
    }

    public void remove(VmResourceId resourceId) {
        String scriptName;
        Object scriptId = resourceId.getId();
        if (scriptId != null) {
            this.scriptIdMap.remove(scriptId);
        }
        if ((scriptName = resourceId.getName()) != null) {
            this.scriptNameMap.remove(scriptName);
        }
    }

    public void clear() {
        this.scriptIdMap.clear();
        this.scriptNameMap.clear();
    }
}

