/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.StreamUtil;

class JavaFileUpdater {
    private final File file;
    private final StringWriter writer;

    JavaFileUpdater(File file) {
        this.file = file;
        this.writer = new StringWriter();
    }

    Writer getWriter() {
        return this.writer;
    }

    void update() throws IOException {
        this.writer.close();
        String newContent = this.writer.getBuffer().toString();
        if (this.file.isFile()) {
            String oldContent = StreamUtil.readStringFromStream(new FileInputStream(this.file), StreamUtil.UTF8_CHARSET);
            if (JavaFileUpdater.stripHeader(oldContent).equals(JavaFileUpdater.stripHeader(newContent))) {
                return;
            }
        } else {
            File dir = this.file.getParentFile();
            boolean dirCreated = dir.mkdirs();
            if (!dirCreated && !dir.isDirectory()) {
                throw new RuntimeException("Failed to create directory " + dir.getPath());
            }
        }
        FileOutputStream outputStream = new FileOutputStream(this.file);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)outputStream, StreamUtil.UTF8_CHARSET);
        fileWriter.write(newContent);
        ((Writer)fileWriter).close();
        ((OutputStream)outputStream).close();
    }

    private static String stripHeader(String content) {
        int pos = content.indexOf("\npackage ");
        if (pos == -1) {
            return content;
        }
        return content.substring(pos);
    }
}

