/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.roster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.presence.PresencePlugin;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceSender;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionListener;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;

public abstract class AbstractRosterManager
implements IRosterManager {
    protected IRoster roster;
    private List rosterSubscriptionListeners = new ArrayList();
    private List rosterUpdateListeners = new ArrayList();

    public AbstractRosterManager() {
    }

    public AbstractRosterManager(IRoster roster) {
        this.roster = roster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRosterSubscriptionListener(IRosterSubscriptionListener listener) {
        if (listener != null) {
            List list = this.rosterSubscriptionListeners;
            synchronized (list) {
                this.rosterSubscriptionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRosterListener(IRosterListener listener) {
        if (listener != null) {
            List list = this.rosterUpdateListeners;
            synchronized (list) {
                this.rosterUpdateListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRosterUpdate(IRosterItem changedItem) {
        ArrayList toNotify = null;
        List list = this.rosterUpdateListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.rosterUpdateListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IRosterListener)i.next()).handleRosterUpdate(this.roster, changedItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRosterAdd(IRosterEntry entry) {
        ArrayList toNotify = null;
        List list = this.rosterUpdateListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.rosterUpdateListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IRosterListener)i.next()).handleRosterEntryAdd(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRosterRemove(IRosterEntry entry) {
        ArrayList toNotify = null;
        List list = this.rosterUpdateListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.rosterUpdateListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IRosterListener)i.next()).handleRosterEntryRemove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSubscriptionListener(ID fromID, IPresence.Type presencetype) {
        ArrayList toNotify = null;
        List list = this.rosterSubscriptionListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.rosterSubscriptionListeners);
        }
        for (IRosterSubscriptionListener l : toNotify) {
            if (presencetype.equals(IPresence.Type.SUBSCRIBE)) {
                l.handleSubscribeRequest(fromID);
                continue;
            }
            if (presencetype.equals(IPresence.Type.SUBSCRIBED)) {
                l.handleSubscribed(fromID);
                continue;
            }
            if (!presencetype.equals(IPresence.Type.UNSUBSCRIBED)) continue;
            l.handleUnsubscribed(fromID);
        }
    }

    @Override
    public abstract IPresenceSender getPresenceSender();

    @Override
    public IRoster getRoster() {
        return this.roster;
    }

    @Override
    public abstract IRosterSubscriptionSender getRosterSubscriptionSender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeRosterSubscriptionListener(IRosterSubscriptionListener listener) {
        if (listener != null) {
            List list = this.rosterSubscriptionListeners;
            synchronized (list) {
                this.rosterSubscriptionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeRosterListener(IRosterListener listener) {
        if (listener != null) {
            List list = this.rosterUpdateListeners;
            synchronized (list) {
                this.rosterUpdateListeners.remove(listener);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = PresencePlugin.getDefault().getAdapterManager();
        if (adapterManager != null) {
            return adapterManager.loadAdapter((Object)this, adapter.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.roster.getItems().clear();
        this.fireRosterUpdate(this.roster);
        List list = this.rosterUpdateListeners;
        synchronized (list) {
            this.rosterUpdateListeners.clear();
        }
        list = this.rosterSubscriptionListeners;
        synchronized (list) {
            this.rosterSubscriptionListeners.clear();
        }
    }
}

