/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private int bufferSize;

    public StreamUtil(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public StreamUtil() {
        this(4096);
    }

    public long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(this.bufferSize);
        this.copy(input, output);
        return output.toByteArray();
    }

    public void writeByteArray(OutputStream outs, byte[] bytes) throws IOException {
        this.copy(new ByteArrayInputStream(bytes), outs);
    }
}

