/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.datashare;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.provider.datashare.DatashareContainerAdapterFactory;
import org.eclipse.ecf.provider.generic.SSLClientSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPClientSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.datashare";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    private AdapterManagerTracker adapterManagerTracker = null;
    private ServiceTracker containerManagerTracker = null;

    public Activator() {
        plugin = this;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(ctxt){

            protected void runWithoutRegistry() throws Exception {
                IAdapterManager am = Activator.this.getAdapterManager();
                if (am != null) {
                    DatashareContainerAdapterFactory af = new DatashareContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, SSLServerSOContainer.class);
                    af = new DatashareContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, TCPServerSOContainer.class);
                    af = new DatashareContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, SSLClientSOContainer.class);
                    af = new DatashareContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, TCPClientSOContainer.class);
                }
            }
        });
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public IAdapterManager getAdapterManager() {
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(this.context, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

