/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectCreateException;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectDeactivatedEvent;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelConfig;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelContainerListener;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelActivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelDeactivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerEvent;
import org.eclipse.ecf.internal.provider.datashare.Activator;
import org.eclipse.ecf.provider.datashare.BaseChannel;

public class SharedObjectDatashareContainerAdapter
extends BaseSharedObject
implements IChannelContainerAdapter {
    protected static final int DEFAULT_TRANSACTION_WAIT = 30000;
    protected List channelContainerListeners = Collections.synchronizedList(new ArrayList());

    protected void initialize() throws SharedObjectInitException {
        super.initialize();
        this.addEventProcessor(new IEventProcessor(){

            public boolean processEvent(Event event) {
                ISharedObjectDeactivatedEvent sode;
                if (event instanceof ISharedObjectActivatedEvent) {
                    final ISharedObjectActivatedEvent soae = (ISharedObjectActivatedEvent)event;
                    if (!soae.getActivatedID().equals((Object)SharedObjectDatashareContainerAdapter.this.getID())) {
                        SharedObjectDatashareContainerAdapter.this.fireChannelContainerListeners((IChannelContainerEvent)new IChannelContainerChannelActivatedEvent(){

                            public ID getChannelID() {
                                return soae.getActivatedID();
                            }

                            public ID getChannelContainerID() {
                                return soae.getLocalContainerID();
                            }

                            public String toString() {
                                StringBuffer buf = new StringBuffer("ChannelActivatedEvent[");
                                buf.append("channelid=").append(soae.getActivatedID()).append(";");
                                buf.append("containerid=").append(soae.getLocalContainerID()).append("]");
                                return buf.toString();
                            }
                        });
                    }
                } else if (event instanceof ISharedObjectDeactivatedEvent && !(sode = (ISharedObjectDeactivatedEvent)event).getDeactivatedID().equals((Object)SharedObjectDatashareContainerAdapter.this.getID())) {
                    SharedObjectDatashareContainerAdapter.this.fireChannelContainerListeners((IChannelContainerEvent)new IChannelContainerChannelDeactivatedEvent(){

                        public ID getChannelID() {
                            return sode.getDeactivatedID();
                        }

                        public ID getChannelContainerID() {
                            return sode.getLocalContainerID();
                        }

                        public String toString() {
                            StringBuffer buf = new StringBuffer("ChannelDeactivatedEvent[");
                            buf.append("channelid=").append(sode.getDeactivatedID()).append(";");
                            buf.append("containerid=").append(sode.getLocalContainerID()).append("]");
                            return buf.toString();
                        }
                    });
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChannelContainerListeners(IChannelContainerEvent event) {
        List list = this.channelContainerListeners;
        synchronized (list) {
            for (IChannelContainerListener l : this.channelContainerListeners) {
                if (l == null) continue;
                l.handleChannelContainerEvent(event);
            }
        }
    }

    public IChannel createChannel(final ID newID, final IChannelListener listener, final Map properties) throws ECFException {
        return this.createChannel(new IChannelConfig(){

            public IChannelListener getListener() {
                return listener;
            }

            public ID getID() {
                return newID;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public Map getProperties() {
                return properties;
            }
        });
    }

    protected SharedObjectDescription createChannelSharedObjectDescription(IChannelConfig channelConfig) throws ECFException {
        return new SharedObjectDescription(BaseChannel.class, channelConfig.getID(), channelConfig.getProperties());
    }

    protected ISharedObjectTransactionConfig createChannelSharedObjectTransactionConfig() {
        return null;
    }

    protected ISharedObject createSharedObject(SharedObjectTypeDescription typeDescription, ISharedObjectTransactionConfig transactionConfig, IChannelListener listener) throws SharedObjectCreateException {
        try {
            Class<?> clazz = Class.forName(typeDescription.getClassName());
            Constructor<?> cons = clazz.getDeclaredConstructor(ISharedObjectTransactionConfig.class, IChannelListener.class);
            return (ISharedObject)cons.newInstance(transactionConfig, listener);
        }
        catch (Exception e) {
            throw new SharedObjectCreateException("Cannot create shared object of class=" + typeDescription.getClassName(), (Throwable)e);
        }
    }

    public IChannel createChannel(IChannelConfig newChannelConfig) throws ECFException {
        SharedObjectDescription sodesc = this.createChannelSharedObjectDescription(newChannelConfig);
        SharedObjectTypeDescription sotypedesc = sodesc.getTypeDescription();
        IChannelListener listener = newChannelConfig.getListener();
        ISharedObjectTransactionConfig transactionConfig = this.createChannelSharedObjectTransactionConfig();
        ISharedObject so = null;
        so = sotypedesc.getName() != null ? SharedObjectFactory.getDefault().createSharedObject(sotypedesc, new Object[]{transactionConfig, listener}) : this.createSharedObject(sotypedesc, transactionConfig, listener);
        IChannel channel = (IChannel)so.getAdapter(IChannel.class);
        if (channel == null) {
            throw new SharedObjectCreateException("channel must not be null");
        }
        ID newID = sodesc.getID();
        if (newID == null) {
            newID = IDFactory.getDefault().createGUID();
        }
        this.getContext().getSharedObjectManager().addSharedObject(newID, so, sodesc.getProperties());
        return channel;
    }

    public IChannel getChannel(ID channelID) {
        if (channelID == null || channelID.equals((Object)this.getID())) {
            return null;
        }
        return (IChannel)this.getContext().getSharedObjectManager().getSharedObject(channelID);
    }

    public boolean removeChannel(ID channelID) {
        if (channelID == null || channelID.equals((Object)this.getID())) {
            return false;
        }
        ISharedObject o = this.getContext().getSharedObjectManager().removeSharedObject(channelID);
        if (o != null && o instanceof IChannel) {
            ((IChannel)o).dispose();
            return true;
        }
        return false;
    }

    public Namespace getChannelNamespace() {
        return IDFactory.getDefault().getNamespaceByName(StringID.class.getName());
    }

    public void addListener(IChannelContainerListener listener) {
        this.channelContainerListeners.add(listener);
    }

    public void removeListener(IChannelContainerListener listener) {
        this.channelContainerListeners.add(listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.isAssignableFrom(IContainer.class)) {
            IContainerManager containerManager = Activator.getDefault().getContainerManager();
            return containerManager.getContainer(this.getContext().getLocalContainerID());
        }
        return super.getAdapter(adapter);
    }
}

