/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core.sharedobject;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.sharedobject.ISharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.provider.ISharedObjectInstantiator;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.core.util.Trace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.sharedobject";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String PROPERTY_ELEMENT_NAME = "property";
    protected static final String VALUE_ATTRIBUTE = "value";
    protected static final String NAMESPACE_NAME = "sharedObjectFactory";
    protected static final String SHAREDOBJECT_FACTORY_EPOINT = "org.eclipse.ecf.sharedobject.sharedObjectFactory";
    protected static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final int REMOVE_SHAREDOBJECT_ERRORCODE = 1001;
    private static final int FACTORY_NAME_COLLISION_ERRORCODE = 2001;
    private static Activator plugin;
    BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    private AdapterManagerTracker adapterManagerTracker = null;
    private LogService systemLogService = null;

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        plugin = this;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithRegistry(IExtensionRegistry registry) throws Exception {
                IExtensionPoint extensionPoint;
                if (registry != null && (extensionPoint = registry.getExtensionPoint(Activator.SHAREDOBJECT_FACTORY_EPOINT)) != null) {
                    Activator.this.addSharedObjectExtensions(extensionPoint.getConfigurationElements());
                }
            }
        });
        Trace.exiting((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/methods/entering", Activator.class, (String)"start");
    }

    public void stop(BundleContext ctxt) throws Exception {
        Trace.entering((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/methods/exiting", Activator.class, (String)"stop");
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    protected LogService getLogService() {
        if (this.context == null) {
            if (this.systemLogService == null) {
                this.systemLogService = new SystemLogService(PLUGIN_ID);
            }
            return this.systemLogService;
        }
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public IAdapterManager getAdapterManager() {
        if (this.context == null) {
            return null;
        }
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    void removeSharedObjectExtensions(IConfigurationElement[] members) {
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String name = null;
            try {
                ISharedObjectFactory factory;
                SharedObjectTypeDescription sd;
                name = member.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if (name != null && (sd = (factory = SharedObjectFactory.getDefault()).getDescriptionByName(name)) != null && factory.containsDescription(sd)) {
                    factory.removeDescription(sd);
                    Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("removeSharedObjectExtensions.removedDescription(" + sd + ")"));
                }
            }
            catch (Exception e) {
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", Activator.class, (String)"removeSharedObjectExtensions", (Throwable)e);
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 1001, "Exception removing sharedobject extension", (Throwable)e));
            }
            ++m;
        }
    }

    void addSharedObjectExtensions(IConfigurationElement[] members) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            ISharedObjectInstantiator exten = null;
            String name = null;
            try {
                String description;
                exten = (ISharedObjectInstantiator)member.createExecutableExtension(CLASS_ATTRIBUTE);
                name = member.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if ((description = member.getAttribute(DESCRIPTION_ATTRIBUTE)) == null) {
                    description = "";
                }
                IConfigurationElement[] propertyElements = member.getChildren(PROPERTY_ELEMENT_NAME);
                Properties props = new Properties();
                if (propertyElements != null && propertyElements.length > 0) {
                    int i = 0;
                    while (i < propertyElements.length) {
                        String name1 = propertyElements[i].getAttribute(NAME_ATTRIBUTE);
                        String value = propertyElements[i].getAttribute(VALUE_ATTRIBUTE);
                        if (name1 != null && !name1.equals("") && value != null && !value.equals("")) {
                            props.setProperty(name1, value);
                        }
                        ++i;
                    }
                }
                Properties properties = props;
                SharedObjectTypeDescription scd = new SharedObjectTypeDescription(name, exten, description, properties);
                Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("setupSharedObjectExtensionPoint:createdDescription(" + scd + ")"));
                ISharedObjectFactory factory = SharedObjectFactory.getDefault();
                if (factory.containsDescription(scd)) {
                    throw new CoreException((IStatus)new Status(4, bundleName, 2001, "name=" + name + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
                }
                factory.addDescription(scd);
                Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("setupSharedObjectExtensionPoint.addedDescriptionToFactory(" + scd + ")"));
            }
            catch (CoreException e) {
                Activator.getDefault().log(e.getStatus());
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", Activator.class, (String)"addSharedObjectExtensions", (Throwable)e);
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, bundleName, 2001, "name=" + name + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", Activator.class, (String)"addSharedObjectExtensions", (Throwable)e);
            }
            ++m;
        }
    }
}

