/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.json;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Hashtable;
import org.eclipse.persistence.internal.databaseaccess.DatabaseJsonPlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;

public class JsonPlatform
implements DatabaseJsonPlatform {
    private static final int JSON_VARCHAR_SIZE = 2048;

    public boolean isJsonType(Type type) {
        switch (type.getTypeName()) {
            case "jakarta.json.JsonValue": 
            case "jakarta.json.JsonArray": 
            case "jakarta.json.JsonObject": {
                return true;
            }
        }
        return false;
    }

    public void updateFieldTypes(Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping) {
        fieldTypeMapping.put(JsonObject.class, new FieldTypeDefinition("VARCHAR", 2048));
        fieldTypeMapping.put(JsonArray.class, new FieldTypeDefinition("VARCHAR", 2048));
        fieldTypeMapping.put(JsonValue.class, new FieldTypeDefinition("VARCHAR", 2048));
    }

    public <T> T convertJsonValueToDataValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        StringWriter sw = new StringWriter(128);
        try (JsonWriter jw = Json.createWriter((Writer)sw);){
            jw.write(jsonValue);
        }
        return (T)sw.toString();
    }

    public JsonValue convertDataValueToJsonValue(Object jdbcValue) {
        if (jdbcValue == null) {
            return null;
        }
        try (JsonReader jr = Json.createReader((Reader)new StringReader((String)jdbcValue));){
            JsonValue jsonValue = jr.readValue();
            return jsonValue;
        }
    }
}

