/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

public class NameUtils {
    public static final String SYSTEM_NAMESPACE_PREFIX = "sys";
    public static final char CHILD_SEPARATOR = '.';
    public static final char TENANT_SEPARATOR = '@';
    public static final char NAMESPACE_SEPARATOR = ':';

    public static String makeQualifiedName(String namespace, String fullName) {
        if (namespace == null || namespace.isEmpty()) {
            return fullName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(namespace).append(':').append(fullName);
        return sb.toString();
    }

    public static String makeQualifiedName(String namespace, String name, String parentName) {
        StringBuilder sb = new StringBuilder();
        if (namespace != null && !namespace.isEmpty()) {
            sb.append(namespace);
        }
        if (parentName != null && !parentName.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(parentName);
            if (name != null && !name.isEmpty()) {
                sb.append('.').append(name);
            }
            return sb.toString();
        }
        if (name != null && !name.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static String getFullNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int nsSeparator = qualifiedName.indexOf(58);
        if (nsSeparator < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(nsSeparator + 1);
    }

    public static String getNamespaceFromQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int nsSeparator = qualifiedName.indexOf(58);
        if (nsSeparator < 0) {
            int tnSeparator = qualifiedName.indexOf(64);
            if (tnSeparator < 0) {
                return null;
            }
            return qualifiedName.substring(0, tnSeparator);
        }
        return qualifiedName.substring(0, nsSeparator);
    }

    public static boolean isInternalInitialNamespace(String namespace) {
        if (namespace == null) {
            return true;
        }
        int tSep = namespace.indexOf(64);
        return tSep >= 0 && tSep == namespace.length() - 1;
    }

    public static String switchToInternalUse(String namespace) {
        assert (namespace == null || !namespace.isEmpty()) : "Empty namespace is not valid.";
        if ("sysdefault".equalsIgnoreCase(namespace)) {
            return null;
        }
        return namespace;
    }

    public static String switchToExternalUse(String namespace) {
        assert (namespace == null || !namespace.isEmpty()) : "Empty namespace is not valid.";
        if (namespace == null) {
            return "sysdefault";
        }
        return namespace;
    }

    public static boolean namespaceEquals(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null;
        }
        return ns1.equalsIgnoreCase(ns2);
    }
}

