/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import com.sleepycat.util.PackedInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ChannelOutput {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final Queue<Chunk> chunkQueue = new ConcurrentLinkedQueue<Chunk>();

    public Queue<Chunk> getChunkQueue() {
        return this.chunkQueue;
    }

    public Chunk beginChunk(int maxSizeNoBuf, boolean last) {
        return new Chunk(maxSizeNoBuf, last);
    }

    public void close() {
        this.chunkQueue.clear();
    }

    public class Chunk {
        private final byte[] bytesForNoBuf;
        private final ByteBuffer bufForNoBuf;
        private int addBufPos = 0;
        private final List<ByteBuffer> chunkbuf;
        private final boolean last;
        private volatile ByteBuffer[] chunkArray = null;

        public Chunk(int maxSizeNoBuf, boolean last) {
            this.bytesForNoBuf = new byte[maxSizeNoBuf];
            this.bufForNoBuf = ByteBuffer.wrap(this.bytesForNoBuf);
            this.chunkbuf = new ArrayList<ByteBuffer>();
            this.last = last;
        }

        public void writeByte(byte v) {
            this.ensureChunkArrayNull();
            this.bufForNoBuf.put(v);
        }

        public void writePackedLong(long v) {
            this.ensureChunkArrayNull();
            int pos = this.bufForNoBuf.position();
            int newPos = PackedInteger.writeLong(this.bytesForNoBuf, pos, v);
            this.bufForNoBuf.position(newPos);
        }

        public void writeUTF8(String s, int maxLength) {
            this.ensureChunkArrayNull();
            CharBuffer chbuf = CharBuffer.wrap(s);
            ByteBuffer buf = utf8.encode(chbuf);
            int length = buf.limit();
            if (length > maxLength) {
                buf.limit(maxLength);
                length = buf.limit();
            }
            this.writePackedLong(length);
            this.addBuf();
            this.chunkbuf.add(buf);
        }

        public void writeBytes(List<ByteBuffer> buflist) {
            this.ensureChunkArrayNull();
            this.addBuf();
            this.chunkbuf.addAll(buflist);
        }

        public void done() {
            this.ensureChunkArrayNull();
            this.addBuf();
            this.chunkArray = this.chunkbuf.toArray(new ByteBuffer[this.chunkbuf.size()]);
            ChannelOutput.this.chunkQueue.add(this);
            this.chunkbuf.clear();
        }

        public ByteBuffer[] chunkArray() {
            return this.chunkArray;
        }

        public boolean last() {
            return this.last;
        }

        private void ensureChunkArrayNull() {
            if (this.chunkArray != null) {
                throw new IllegalStateException("Operation on chunk after it is done");
            }
        }

        private void addBuf() {
            int pos = this.bufForNoBuf.position();
            assert (this.addBufPos <= pos);
            if (this.addBufPos == pos) {
                return;
            }
            ByteBuffer buf = this.bufForNoBuf.duplicate();
            buf.position(this.addBufPos);
            buf.limit(pos);
            this.chunkbuf.add(buf);
            this.addBufPos = pos;
        }
    }
}

