/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractEndpointGroup;
import oracle.kv.impl.async.AbstractListener;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.netty.NettyCreatorEndpoint;
import oracle.kv.impl.async.dialog.netty.NettyResponderEndpoint;
import oracle.kv.impl.async.dialog.netty.NettyUtil;

public class NettyEndpointGroup
extends AbstractEndpointGroup {
    private static boolean logHandlerEnabled = false;
    private final EventLoopGroup eventLoopGroup;

    public NettyEndpointGroup(Logger logger, int nthreads) throws Exception {
        super(logger);
        this.eventLoopGroup = new NioEventLoopGroup(nthreads);
    }

    public static void enableLogHandler() {
        logHandlerEnabled = true;
    }

    public static void disableLogHandler() {
        logHandlerEnabled = false;
    }

    public static boolean logHandlerEnabled() {
        return logHandlerEnabled;
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.eventLoopGroup;
    }

    @Override
    protected NettyCreatorEndpoint newCreatorEndpoint(NetworkAddress address, EndpointConfig endpointConfig) {
        return new NettyCreatorEndpoint(this, this.eventLoopGroup, address, endpointConfig);
    }

    @Override
    protected NettyListener newListener(AbstractEndpointGroup endpointGroup, ListenerConfig listenerConfig, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
        return new NettyListener(endpointGroup, listenerConfig, dialogHandlerFactories);
    }

    @Override
    protected void shutdownInternal(boolean force) {
        if (force) {
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        } else {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
    }

    class NettyListener
    extends AbstractListener {
        private Channel listeningChannel;

        NettyListener(AbstractEndpointGroup endpointGroup, ListenerConfig listenerConfig, Map<Integer, DialogHandlerFactory> dialogHandlerFactories) {
            super(endpointGroup, listenerConfig, dialogHandlerFactories);
            this.listeningChannel = null;
        }

        @Override
        protected void createChannel() throws IOException {
            if (this.listeningChannel == null) {
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(NettyEndpointGroup.this.eventLoopGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new ChannelErrorHandler())).childHandler((ChannelHandler)new Initializer());
                this.listeningChannel = NettyUtil.listen(serverBootstrap, this.listenerConfig);
            }
        }

        @Override
        protected void closeChannel() {
            if (this.listeningChannel == null) {
                return;
            }
            this.listeningChannel.close();
            this.listeningChannel = null;
        }

        @Override
        protected NetworkAddress getLocalAddress() {
            if (this.listeningChannel == null) {
                return null;
            }
            return NettyUtil.getLocalAddress(this.listeningChannel);
        }

        private class ChannelErrorHandler
        extends ChannelInboundHandlerAdapter {
            private ChannelErrorHandler() {
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                NettyListener.this.onChannelError(cause, !ctx.channel().isOpen());
            }
        }

        private class Initializer
        extends ChannelInitializer<SocketChannel> {
            private Initializer() {
            }

            public void initChannel(SocketChannel channel) {
                InetSocketAddress addr = channel.remoteAddress();
                NetworkAddress remoteAddress = new NetworkAddress(addr.getHostName(), addr.getPort());
                NettyResponderEndpoint endpoint = new NettyResponderEndpoint(NettyEndpointGroup.this, remoteAddress, NettyListener.this.listenerConfig, NettyListener.this, NettyListener.this.endpointConfig);
                NettyListener.this.acceptedEndpoints.add(endpoint);
                NettyEndpointGroup.this.addResponderEndpoint(endpoint);
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{endpoint.getHandler()});
            }
        }
    }
}

