/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import oracle.kv.impl.measurement.ConciseStats;
import oracle.kv.impl.util.FormatUtils;

public class EnvStats
implements ConciseStats,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EnvironmentStats envStats;
    private final long start;
    private final long end;

    public EnvStats(long start, long end, EnvironmentStats stats) {
        this.start = start;
        this.end = end;
        this.envStats = stats;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    public String toString() {
        return "Environment stats [" + FormatUtils.formatTime(this.end) + "]\n" + this.envStats.toString();
    }

    public EnvironmentStats getStats() {
        return this.envStats;
    }

    @Override
    public String getFormattedStats() {
        StringBuilder sb = new StringBuilder();
        for (StatGroup sg : this.envStats.getStatGroups()) {
            sb.append(sg.toStringConcise());
        }
        return sb.toString();
    }
}

