/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerializationUtil;

public class ExternalVarRefIter
extends PlanIter {
    private final String theName;
    private final int theId;

    public ExternalVarRefIter(Expr e, int resultReg, int id, String name) {
        super(e, resultReg);
        this.theName = name;
        this.theId = id;
    }

    ExternalVarRefIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theName = serialVersion >= 15 ? SerializationUtil.readString(in, serialVersion) : in.readUTF();
        this.theId = ExternalVarRefIter.readPositiveInt(in);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 15) {
            SerializationUtil.writeString(out, serialVersion, this.theName);
        } else {
            out.writeUTF(this.theName);
        }
        out.writeInt(this.theId);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.EXTERNAL_VAR_REF;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        FieldValueImpl val = rcb.getExternalVar(this.theId);
        if (val == null) {
            throw new QueryStateException("Variable " + this.theName + " has not been set");
        }
        rcb.setRegVal(this.theResultReg, val);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayContent(sb, formatter);
        this.displayRegs(sb);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        sb.append("EXTENAL_VAR_REF(");
        sb.append(this.theName);
        sb.append(", ").append(this.theId);
        sb.append(")");
    }
}

