/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.IndexKey;
import oracle.kv.table.PrimaryKey;

public class KeyPair
implements Comparable<KeyPair> {
    private static final String INDEX_KEY_NAME = "IndexKey";
    private static final String PRIMARY_KEY_NAME = "PrimaryKey";
    private final PrimaryKey primaryKey;
    private final IndexKey indexKey;

    public KeyPair(PrimaryKey primaryKey, IndexKey indexKey) {
        this.primaryKey = primaryKey;
        this.indexKey = indexKey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public IndexKey getIndexKey() {
        return this.indexKey;
    }

    @Override
    public int compareTo(KeyPair other) {
        int value = this.indexKey.compareTo(other.getIndexKey());
        if (value == 0) {
            value = this.primaryKey.compareTo(other.getPrimaryKey());
        }
        return value;
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append('{');
        sb.append('\"');
        sb.append(INDEX_KEY_NAME);
        sb.append('\"');
        sb.append(':');
        ((FieldValueImpl)((Object)this.indexKey)).toStringBuilder(sb);
        sb.append(',');
        sb.append('\"');
        sb.append(PRIMARY_KEY_NAME);
        sb.append('\"');
        sb.append(':');
        ((FieldValueImpl)((Object)this.primaryKey)).toStringBuilder(sb);
        sb.append('}');
        return sb.toString();
    }
}

