/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AreaRenderer
extends SWTPartRenderer {
    @Inject
    private IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MArea)) {
                return;
            }
            MArea areaModel = (MArea)event.getProperty("ChangedElement");
            CTabFolder ctf = (CTabFolder)areaModel.getWidget();
            CTabItem areaItem = ctf.getItem(0);
            if (areaItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName) || "localizedLabel".equals(attName)) {
                areaItem.setText(areaModel.getLocalizedLabel());
            } else if ("iconURI".equals(attName)) {
                areaItem.setImage(AreaRenderer.this.getImage((MUILabel)areaModel));
            } else if ("tooltip".equals(attName) || "localizedTooltip".equals(attName)) {
                areaItem.setToolTipText(areaModel.getLocalizedTooltip());
            }
        }
    };
    private EventHandler widgetListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPartStack)) {
                return;
            }
            MArea areaModel = this.findArea(changedElement);
            if (areaModel != null) {
                AreaRenderer.this.synchCTFState(areaModel);
            }
        }

        private MArea findArea(MUIElement element) {
            MElementContainer parent = element.getParent();
            while (parent != null) {
                if (parent instanceof MArea) {
                    return (MArea)parent;
                }
                parent = parent.getParent();
            }
            return null;
        }
    };

    @PostConstruct
    void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.itemUpdater);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetListener);
    }

    @PreDestroy
    void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.widgetListener);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MArea) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        Composite areaComp = new Composite(parentComp, 0);
        areaComp.setLayout((Layout)new FillLayout());
        return areaComp;
    }

    private void ensureCTF(MArea areaModel) {
        if (areaModel.getWidget() instanceof CTabFolder) {
            return;
        }
        Composite curComp = (Composite)areaModel.getWidget();
        Composite parentComp = curComp.getParent();
        CTabFolder ctf = new CTabFolder(parentComp, 2052);
        List stacks = this.modelService.findElements((MUIElement)areaModel, null, MPartStack.class, null);
        MPartStack curStack = null;
        for (MPartStack stack : stacks) {
            CTabFolder stackCTF;
            if (!stack.isToBeRendered() || !(stack.getWidget() instanceof CTabFolder) || !(stackCTF = (CTabFolder)stack.getWidget()).getMinimizeVisible() && !stackCTF.getMaximizeVisible()) continue;
            curStack = stack;
            break;
        }
        if (curStack != null) {
            CTabFolder curCTF = (CTabFolder)curStack.getWidget();
            ctf.setMinimizeVisible(curCTF.getMinimizeVisible());
            ctf.setMaximizeVisible(curCTF.getMaximizeVisible());
            ctf.setMinimized(curCTF.getMinimized());
            ctf.setMaximized(curCTF.getMaximized());
            curCTF.setMinimizeVisible(false);
            curCTF.setMaximizeVisible(false);
        }
        CTabItem cti = new CTabItem(ctf, 0);
        if (areaModel.getLabel() != null) {
            cti.setText(areaModel.getLocalizedLabel());
        }
        if (areaModel.getTooltip() != null) {
            cti.setToolTipText(areaModel.getLocalizedTooltip());
        }
        if (areaModel.getIconURI() != null) {
            cti.setImage(this.getImage((MUILabel)areaModel));
        }
        curComp.setParent((Composite)ctf);
        cti.setControl((Control)curComp);
        ctf.setSelection(cti);
        curComp.setData("modelElement", null);
        this.bindWidget((MUIElement)areaModel, ctf);
        ctf.getParent().layout(null, 7);
    }

    private void ensureComposite(MArea areaModel) {
        if (areaModel.getWidget() instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)areaModel.getWidget();
            CTabItem cti = ctf.getItem(0);
            Composite innerComp = (Composite)cti.getControl();
            innerComp.setParent(ctf.getParent());
            cti.setControl(null);
            List stacks = this.modelService.findElements((MUIElement)areaModel, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                if (!stack.isToBeRendered() || !(stack.getWidget() instanceof CTabFolder)) continue;
                CTabFolder stackCTF = (CTabFolder)stack.getWidget();
                stackCTF.setMinimizeVisible(ctf.getMinimizeVisible());
                stackCTF.setMaximizeVisible(ctf.getMaximizeVisible());
                stackCTF.setMinimized(ctf.getMinimized());
                stackCTF.setMaximized(ctf.getMaximized());
            }
            ctf.setData("modelElement", null);
            ctf.dispose();
            this.bindWidget((MUIElement)areaModel, innerComp);
            innerComp.setVisible(true);
            innerComp.getParent().layout(true, true);
        }
    }

    private void synchCTFState(MArea areaModel) {
        List stacks = this.modelService.findElements((MUIElement)areaModel, null, MPartStack.class, null);
        int count = 0;
        for (MPartStack stack : stacks) {
            if (!stack.isToBeRendered()) continue;
            ++count;
        }
        if (count > 1) {
            this.ensureCTF(areaModel);
        } else {
            this.ensureComposite(areaModel);
        }
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parentElement = element.getParent();
        if (!(parentElement instanceof MArea)) {
            return null;
        }
        MArea areaModel = (MArea)parentElement;
        this.synchCTFState(areaModel);
        if (areaModel.getWidget() instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)areaModel.getWidget();
            return ctf.getItem(0).getControl();
        }
        return parentElement.getWidget();
    }
}

