/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ViewpointLabelProvider
extends LabelProvider {
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    public Image getImage(Object object) {
        Image labelImage = null;
        if (object != null && !object.equals(StructuredSelection.EMPTY)) {
            IStructuredSelection structuredSelection;
            if (object instanceof IStructuredSelection && !this.containsDifferentTypes(structuredSelection = (IStructuredSelection)object)) {
                object = structuredSelection.getFirstElement();
            }
            if (object instanceof EObject || object instanceof Resource) {
                labelImage = this.getAdapterFactoryLabelProvider().getImage(object);
            }
        }
        return labelImage;
    }

    public String getText(Object object) {
        Object text = null;
        int selectionSize = 0;
        if (object != null && !object.equals(StructuredSelection.EMPTY) && object instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)object;
            selectionSize = structuredSelection.size();
            if (selectionSize == 1 && structuredSelection.getFirstElement() instanceof EObject) {
                object = structuredSelection.getFirstElement();
            }
            if (this.containsDifferentTypes(structuredSelection)) {
                text = selectionSize + " items selected";
            }
        }
        if (object != null) {
            text = this.getAdapterFactoryLabelProvider().getText(object);
        }
        if (selectionSize > 1) {
            text = selectionSize + " [";
            Iterator iterator = ((IStructuredSelection)object).iterator();
            while (iterator.hasNext()) {
                text = (String)text + this.getAdapterFactoryLabelProvider().getText(iterator.next());
                if (!iterator.hasNext()) continue;
                text = (String)text + ", ";
            }
            text = (String)text + "] selected";
        }
        return text;
    }

    private AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        if (this.adapterFactoryLabelProvider == null) {
            this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(((SiriusEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getAdapterFactory());
        }
        return this.adapterFactoryLabelProvider;
    }

    private boolean containsDifferentTypes(IStructuredSelection structuredSelection) {
        boolean areDistinct = false;
        List selectionList = structuredSelection.toList();
        if (selectionList.size() > 1) {
            Iterator iterator = selectionList.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!iterator.hasNext() || iterator.next().getClass() == element.getClass()) continue;
                areDistinct = true;
            }
        }
        return areDistinct;
    }
}

