/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.AutomaticCreator;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.EvaluatedSemanticPartition;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.MappingHiearchy;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.synchronizer.RefreshPlan;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.synchronizer.SignatureProvider;

public class RefreshPlanner {
    private MappingHiearchyTable mappingTable;
    private SemanticPartitionInvalidator invalidator;
    private PreRefreshStatus pre;
    private SignatureProvider signatureProvider;
    private final Function<Mapping, Collection<MappingHiearchy>> toHierarchy = new Function<Mapping, Collection<MappingHiearchy>>(){

        public Collection<MappingHiearchy> apply(Mapping from) {
            return RefreshPlanner.this.mappingTable.getHierarchy(from);
        }
    };

    public RefreshPlanner(MappingHiearchyTable mappingTable, SemanticPartitionInvalidator invalidator, PreRefreshStatus pre, SignatureProvider signatureProvider) {
        this.mappingTable = mappingTable;
        this.invalidator = invalidator;
        this.pre = pre;
        this.signatureProvider = signatureProvider;
    }

    public RefreshPlan computePlan(CreatedOutput container) {
        RefreshPlan post = new RefreshPlan(this.signatureProvider);
        List<? extends Mapping> childMappings = container.getChildMappings();
        this.pre.computeStatus(container, childMappings);
        post.addPreviousStatus(this.pre.getExistingOutputs());
        Iterable mappingsCreatingElements = Iterables.filter(childMappings, (Predicate)new Predicate<Mapping>(){

            public boolean apply(Mapping input) {
                return input.getCreator().some();
            }
        });
        Iterable transformedHiearchy = Iterables.transform((Iterable)mappingsCreatingElements, this.toHierarchy);
        LinkedHashSet childHiearchies = Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)transformedHiearchy));
        for (MappingHiearchy nodeHiearch : childHiearchies) {
            Iterator<Mapping> it = nodeHiearch.fromMostSpecificToMostGeneral();
            while (it.hasNext()) {
                Mapping cur = it.next();
                if (!cur.isEnabled() || !cur.getCreator().some()) continue;
                Option par = this.invalidator.hasFastResult(container.getDescriptor().getSourceElement(), cur.getSemanticPartition(), container);
                if (!par.some()) {
                    par = Options.newSome((Object)cur.getSemanticPartition().evaluate(container.getDescriptor().getSourceElement(), container));
                }
                Collection<? extends OutputDescriptor> allCandidateDescriptors = ((AutomaticCreator)cur.getCreator().get()).computeDescriptors(container, ((EvaluatedSemanticPartition)par.get()).elements());
                post.appendOutputDescritorsKeepingTheMostSpecific(allCandidateDescriptors);
            }
        }
        return post;
    }
}

