/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTablePropertySection
extends AbstractViewpointPropertySection {
    protected Table table;
    protected CLabel nameLabel;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.table = this.getWidgetFactory().createTable(this.composite, 67588);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.height = 90;
        this.table.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.table, -25);
        data.top = new FormAttachment((Control)this.table, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTablePropertySection.this.handleTableModified();
            }
        });
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected void handleTableModified() {
        int index = this.table.getSelectionIndex();
        boolean equals = this.isEqual(index);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(index);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.table.getItems().length == 0) {
            this.createTableItems();
        }
        String currentlySelected = this.getFeatureAsText();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tItem = tableItemArray[n2];
            if (tItem.getText().equals(currentlySelected)) {
                this.table.setSelection(tItem);
            }
            ++n2;
        }
    }

    protected void createTableItems() {
        List values = this.getChoiceOfValues();
        int currentIndex = 0;
        for (ImageItem imageItem : values) {
            this.newTableItem(imageItem, currentIndex, this.getFeatureAsText());
            ++currentIndex;
        }
    }

    protected TableItem newTableItem(ImageItem imageItem, int index, String currentSelection) {
        Image image = SiriusEditorPlugin.INSTANCE.getBundledImage(imageItem.getImagePath());
        TableItem item = new TableItem(this.table, 0, index);
        if (image != null) {
            item.setImage(image);
        }
        item.setText(imageItem.getText());
        item.setData((Object)imageItem);
        if (currentSelection.equals(imageItem.getText())) {
            this.table.setSelection(index);
        }
        return item;
    }

    protected String[] getTableValues() {
        List values = this.getChoiceOfValues();
        String[] array = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            if (values.get(i) != null) {
                if (values.get(i) instanceof String) {
                    array[i] = (String)values.get(i);
                } else if (values.get(i) instanceof EObject) {
                    array[i] = this.getAdapterFactoryLabelProvider((EObject)values.get(i)).getText(values.get(i));
                } else if (values.get(i) instanceof Enumerator) {
                    array[i] = ((Enumerator)values.get(i)).getName();
                } else if (values.get(i) instanceof ImageItem) {
                    array[i] = ((ImageItem)values.get(i)).getText();
                }
            } else {
                array[i] = new String();
            }
            ++i;
        }
        return array;
    }

    protected abstract boolean isEqual(int var1);

    @Override
    protected abstract EStructuralFeature getFeature();

    protected abstract List getChoiceOfValues();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet(this.getFeature()) != null) {
            value = this.eObject.eGet(this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract Object getFeatureValue(int var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EStructuralFeature eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor(eFeature = this.getFeature())) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.table.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.table.setEnabled(true);
    }

    protected class ImageItem {
        private String imagePath;
        private Enumerator eEnum;

        public ImageItem(Enumerator eEnum, String imagePath) {
            this.setImagePath(imagePath);
            this.setEnum(eEnum);
        }

        public String getText() {
            return this.eEnum.getLiteral();
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public Enumerator getEnum() {
            return this.eEnum;
        }

        private void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }

        private void setEnum(Enumerator eEnum) {
            this.eEnum = eEnum;
        }
    }
}

