/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.view.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;

public class ResultLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    private final AdapterFactoryLabelProvider delegate;
    private Map<String, Image> images = new HashMap<String, Image>();

    public ResultLabelProvider(AdapterFactory adapterFactory) {
        this.delegate = new AdapterFactoryLabelProvider(adapterFactory);
    }

    public void dispose() {
        for (Image image : this.images.values()) {
            image.dispose();
        }
        this.images.clear();
        super.dispose();
    }

    public String getToolTipText(Object element) {
        String text = this.getText(element);
        if (text.indexOf(10) != -1 || text.indexOf(13) != -1) {
            return text;
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        String text = this.getText(element);
        int indexOfNewLine = text.indexOf("\n\r") - 2;
        if (indexOfNewLine < 0) {
            indexOfNewLine = text.indexOf("\n") - 1;
        }
        if (indexOfNewLine < 0) {
            indexOfNewLine = text.indexOf("\r") - 1;
        }
        if (indexOfNewLine >= 0) {
            cell.setText(String.valueOf(text.substring(0, indexOfNewLine)) + "  (...)");
        } else {
            cell.setText(text);
        }
        cell.setImage(this.getImage(element));
    }

    private Image createEditorIcon(String fileName) {
        IEditorDescriptor[] descriptors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(fileName);
        if (descriptors != null) {
            int i = 0;
            while (i < descriptors.length) {
                IEditorDescriptor descriptor = descriptors[i];
                if (descriptor.getImageDescriptor() != null) {
                    Image image = descriptor.getImageDescriptor().createImage();
                    return image;
                }
                ++i;
            }
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName).createImage();
    }

    public Image getImage(Object element) {
        EvaluationResult evaluationResult;
        Image result = null;
        if (element instanceof InterpreterFile) {
            String key = ((InterpreterFile)element).getFileName();
            if (key.indexOf(46) != -1) {
                key = key.substring(key.indexOf(46) + 1);
            }
            if ((result = this.images.get(key)) == null && (result = this.createEditorIcon(((InterpreterFile)element).getFileName())) != null) {
                this.images.put(key, result);
            }
        } else if (element instanceof EvaluationResult && (evaluationResult = (EvaluationResult)element).getEvaluationResult() != null) {
            result = this.delegate.getImage(evaluationResult.getEvaluationResult());
        }
        if (result != null) {
            return result;
        }
        return this.delegate.getImage(element);
    }

    public String getText(Object element) {
        EvaluationResult evaluationResult;
        String text = element instanceof EvaluationResult ? ((evaluationResult = (EvaluationResult)element).getEvaluationResult() != null ? this.delegate.getText(evaluationResult.getEvaluationResult()) : (evaluationResult.getStatus() != null ? evaluationResult.getStatus().getMessage() : "Empty evaluation result")) : (element instanceof InterpreterFile ? ((InterpreterFile)element).getFileName() : this.delegate.getText(element));
        return text;
    }
}

