/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.customcharts.core;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.extensions.axisconverter.PassThroughConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesData;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;

public class PCAChart
extends ScatterChart {
    private Color colorBlack = this.getDisplay().getSystemColor(2);
    private String chartTitle = "";
    private String xAxisTitle = "PC1";
    private String yAxisTitle = "PC2";
    private DecimalFormat decimalFormat = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH));

    public PCAChart() {
        this.initialize();
    }

    public PCAChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void addSeriesData(List<IScatterSeriesData> scatterSeriesDataList) {
        super.addSeriesData(scatterSeriesDataList);
        int symbolSize = 0;
        for (IScatterSeriesData scatterSeriesData : scatterSeriesDataList) {
            symbolSize = Math.max(symbolSize, scatterSeriesData.getSettings().getSymbolSize());
        }
    }

    public void setTitles(String chartTitle, String xAxisTitle, String yAxisTitle) {
        this.chartTitle = chartTitle;
        this.xAxisTitle = xAxisTitle;
        this.yAxisTitle = yAxisTitle;
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setTitle(chartTitle);
        chartSettings.setTitleVisible(true);
        chartSettings.getPrimaryAxisSettingsX().setTitle(xAxisTitle);
        chartSettings.getPrimaryAxisSettingsY().setTitle(yAxisTitle);
        this.applySettings(chartSettings);
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.getPrimaryAxisSettingsX().setDecimalFormat(decimalFormat);
        chartSettings.getPrimaryAxisSettingsY().setDecimalFormat(decimalFormat);
        for (ISecondaryAxisSettings secondaryAxisSettings : chartSettings.getSecondaryAxisSettingsListX()) {
            secondaryAxisSettings.setDecimalFormat(decimalFormat);
        }
        for (ISecondaryAxisSettings secondaryAxisSettings : chartSettings.getSecondaryAxisSettingsListY()) {
            secondaryAxisSettings.setDecimalFormat(decimalFormat);
        }
        this.applySettings(chartSettings);
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setTitle(this.chartTitle);
        chartSettings.setTitleVisible(true);
        chartSettings.setTitleColor(this.colorBlack);
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(false);
        chartSettings.setVerticalSliderVisible(true);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroX(false);
        rangeRestriction.setZeroY(false);
        rangeRestriction.setRestrictFrame(false);
        rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtend(0.25);
        chartSettings.setShowAxisZeroMarker(true);
        chartSettings.setColorAxisZeroMarker(this.colorBlack);
        chartSettings.setShowSeriesLabelMarker(true);
        chartSettings.setColorSeriesLabelMarker(this.colorBlack);
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "PCAChart");
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(this.xAxisTitle);
        primaryAxisSettingsX.setDecimalFormat(this.decimalFormat);
        primaryAxisSettingsX.setColor(this.colorBlack);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(this.yAxisTitle);
        primaryAxisSettingsY.setDecimalFormat(this.decimalFormat);
        primaryAxisSettingsY.setColor(this.colorBlack);
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(this.xAxisTitle, (IAxisScaleConverter)new PassThroughConverter());
        secondaryAxisSettingsX.setTitle("");
        secondaryAxisSettingsX.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsX.setDecimalFormat(this.decimalFormat);
        secondaryAxisSettingsX.setColor(this.colorBlack);
        chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(this.yAxisTitle, (IAxisScaleConverter)new PassThroughConverter());
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(this.decimalFormat);
        secondaryAxisSettingsY.setColor(this.colorBlack);
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }
}

