/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.impl;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.oomph.predicates.impl.PredicateImpl;
import org.eclipse.oomph.workingsets.InclusionPredicate;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;

public class InclusionPredicateImpl
extends PredicateImpl
implements InclusionPredicate {
    protected EList<WorkingSet> includedWorkingSets;

    protected InclusionPredicateImpl() {
    }

    protected EClass eStaticClass() {
        return WorkingSetsPackage.Literals.INCLUSION_PREDICATE;
    }

    @Override
    public EList<WorkingSet> getIncludedWorkingSets() {
        if (this.includedWorkingSets == null) {
            this.includedWorkingSets = new EObjectResolvingEList(WorkingSet.class, (InternalEObject)this, 1);
        }
        return this.includedWorkingSets;
    }

    public boolean matches(IResource resource) {
        for (WorkingSet workingSet : this.getIncludedWorkingSets()) {
            if (!workingSet.matches(resource)) continue;
            return true;
        }
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getIncludedWorkingSets();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getIncludedWorkingSets().clear();
                this.getIncludedWorkingSets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getIncludedWorkingSets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.includedWorkingSets != null && !this.includedWorkingSets.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

