/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public abstract class AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getButton() {
        return 5;
    }

    protected boolean isSingleClick(Event event) {
        return event.count == 1;
    }

    public void showClickbindingHelp(BaseChart chart, String name, String description) {
        chart.openShortcutPopup(this.getFormattedShortcut(), name, description);
    }

    private String getFormattedShortcut() {
        String modifier = "";
        if ((this.getStateMask() & SWT.MOD1) == SWT.MOD1) {
            modifier = AbstractHandledEventProcessor.isMac() ? "CMD" : "CTRL";
        } else if ((this.getStateMask() & SWT.MOD2) == SWT.MOD2) {
            modifier = "SHIFT";
        } else if ((this.getStateMask() & SWT.MOD3) == SWT.MOD3) {
            modifier = "ALT";
        }
        String button = "";
        switch (this.getButton()) {
            case 1: {
                button = "Left";
                break;
            }
            case 2: {
                button = "Middle";
                break;
            }
            case 3: {
                button = "Right";
            }
        }
        String event = "";
        switch (this.getEvent()) {
            case 1: {
                event = "Double Click";
                break;
            }
            case 3: 
            case 5: {
                event = "Click";
            }
        }
        StringBuilder builder = new StringBuilder();
        if (!modifier.isEmpty()) {
            builder.append(modifier);
        }
        if (!button.isEmpty()) {
            if (!modifier.isEmpty()) {
                builder.append(" + " + button + " \ud83d\uddb0");
            } else {
                builder.append(button + " \ud83d\uddb0");
            }
        }
        if (!event.isEmpty()) {
            builder.append(" " + event);
        }
        return builder.toString();
    }

    private static boolean isMac() {
        return AbstractHandledEventProcessor.getOperatingSystem().indexOf("mac") >= 0;
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }
}

