/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.support;

import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.support.PointPrimary;
import org.eclipse.swtchart.extensions.support.RectanglePrimary;

public class ElementSupport {
    private Range rangeX;
    private Range rangeY;
    private double widthChart = 0.0;
    private double heightChart = 0.0;
    private double factorX = 0.0;
    private double factorY = 0.0;
    private double partX = 0.0;
    private double partY = 0.0;
    private boolean coversNegativeRangeY = false;
    private double fullRangeNegativeY = 0.0;
    private double factorUpperRangeY = 0.0;
    private double upperPartY = 0.0;

    public ElementSupport(Range rangeX, Range rangeY, double widthChart, double heightChart) {
        this.rangeX = rangeX;
        this.rangeY = rangeY;
        this.widthChart = widthChart;
        this.heightChart = heightChart;
        this.initialize();
    }

    public Range getRangeX() {
        return this.rangeX;
    }

    public Range getRangeY() {
        return this.rangeY;
    }

    public PointPrimary convertPoint(int x, int y) {
        double primaryX = this.rangeX.lower + this.partX * (this.factorX * (double)x);
        double primaryY = 0.0;
        if (this.coversNegativeRangeY) {
            if ((double)y <= this.upperPartY) {
                primaryY = this.rangeY.upper * (1.0 - this.factorY * (double)y);
            } else {
                double yp = (double)y - this.upperPartY;
                double factorp = 1.0 / (this.heightChart - this.upperPartY) * yp;
                primaryY = this.rangeY.lower * factorp;
            }
        } else {
            primaryY = this.rangeY.lower + this.partY * (1.0 - this.factorY * (double)y);
        }
        return new PointPrimary(primaryX, primaryY);
    }

    public RectanglePrimary convertRectangle(int x, int y, int width, int height) {
        PointPrimary primaryStart = this.convertPoint(x, y);
        PointPrimary primaryStop = this.convertPoint(x + width, y + height);
        double widthPrimary = primaryStop.getX() - primaryStart.getX();
        double heightPrimary = 0.0;
        heightPrimary = this.coversNegativeRangeY ? ((double)y <= this.upperPartY ? (primaryStart.getY() - primaryStop.getY()) * (1.0 / this.factorUpperRangeY) : Math.abs(primaryStop.getY() - primaryStart.getY())) : primaryStart.getY() - primaryStop.getY();
        return new RectanglePrimary(primaryStart.getX(), primaryStart.getY(), widthPrimary, heightPrimary);
    }

    private void initialize() {
        if (this.widthChart > 0.0 && this.heightChart > 0.0) {
            this.factorX = 1.0 / this.widthChart;
            this.factorY = 1.0 / this.heightChart;
        }
        this.partX = this.rangeX.upper - this.rangeX.lower;
        this.partY = this.rangeY.upper - this.rangeY.lower;
        boolean bl = this.coversNegativeRangeY = this.rangeY.lower < 0.0;
        if (this.coversNegativeRangeY) {
            this.fullRangeNegativeY = Math.abs(this.rangeY.lower) + this.rangeY.upper;
            if (this.fullRangeNegativeY > 0.0) {
                this.factorUpperRangeY = 1.0 / this.fullRangeNegativeY * this.rangeY.upper;
                this.upperPartY = this.heightChart * this.factorUpperRangeY;
            }
        }
    }
}

