/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.memory;

import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockUpdatePolicyProvider;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RefreshAction
implements IViewActionDelegate {
    private IMemoryBlock fMemoryBlock = null;
    private IMemoryRenderingSite fsite;

    public void init(IViewPart view) {
        this.fsite = (IMemoryRenderingSite)view;
    }

    public void run(IAction action) {
        if (this.fMemoryBlock instanceof IMemoryBlockUpdatePolicyProvider) {
            ((IMemoryBlockUpdatePolicyProvider)this.fMemoryBlock).clearCache();
            IMemoryRenderingContainer[] containers = this.fsite.getMemoryRenderingContainers();
            int i = 0;
            while (i < containers.length) {
                IMemoryRendering[] renderings = containers[i].getRenderings();
                int j = 0;
                while (j < renderings.length) {
                    if (renderings[j].getControl() instanceof IDebugEventSetListener) {
                        ((IDebugEventSetListener)renderings[j].getControl()).handleDebugEvents(new DebugEvent[]{new DebugEvent((Object)this.fMemoryBlock, 16)});
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fMemoryBlock = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryBlock) {
                this.fMemoryBlock = (IMemoryBlock)((IStructuredSelection)selection).getFirstElement();
                action.setEnabled(true);
            } else if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryRendering) {
                this.fMemoryBlock = ((IMemoryRendering)((IStructuredSelection)selection).getFirstElement()).getMemoryBlock();
                action.setEnabled(true);
            }
        }
    }
}

