/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pdomdepgen;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCalculator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PDOMDependencyCalculator
implements IManagedDependencyCalculator {
    private final IPath source;
    private final IResource resource;
    private final IBuildObject buildContext;
    private final ITool tool;
    private final IPath topBuildDirectory;
    private IPath[] dependencies;

    public PDOMDependencyCalculator(IPath source, IResource resource, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this.source = source;
        this.resource = resource;
        this.buildContext = buildContext;
        this.tool = tool;
        this.topBuildDirectory = topBuildDirectory;
    }

    @Override
    public IPath[] getAdditionalTargets() {
        return null;
    }

    @Override
    public IPath[] getDependencies() {
        if (this.dependencies == null) {
            if (this.resource != null) {
                ICProject project = CoreModel.getDefault().create(this.resource.getProject());
                try {
                    IIndex index = CCorePlugin.getIndexManager().getIndex(project, 1);
                    index.acquireReadLock();
                    try {
                        IIndexFile[] files = index.getFiles(IndexLocationFactory.getWorkspaceIFL((IFile)((IFile)this.resource)));
                        if (files.length > 0) {
                            IIndexInclude[] includes = index.findIncludes(files[0], -1);
                            ArrayList<IPath> list = new ArrayList<IPath>();
                            IIndexInclude[] iIndexIncludeArray = includes;
                            int n = includes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IIndexInclude inc = iIndexIncludeArray[n2];
                                if (inc.isResolved()) {
                                    list.add(IndexLocationFactory.getAbsolutePath((IIndexFileLocation)inc.getIncludesLocation()));
                                }
                                ++n2;
                            }
                            this.dependencies = list.toArray(new IPath[list.size()]);
                        } else {
                            this.dependencies = new IPath[0];
                        }
                    }
                    finally {
                        index.releaseReadLock();
                    }
                }
                catch (CoreException e) {
                    this.dependencies = new IPath[0];
                }
                catch (InterruptedException e) {
                    this.dependencies = new IPath[0];
                }
            } else {
                this.dependencies = new IPath[0];
            }
        }
        return this.dependencies;
    }

    @Override
    public IBuildObject getBuildContext() {
        return this.buildContext;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public ITool getTool() {
        return this.tool;
    }

    @Override
    public IPath getTopBuildDirectory() {
        return this.topBuildDirectory;
    }
}

