/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.util.List;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.actions.AbstractAutotoolsHandler;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.internal.autotools.ui.actions.SingleInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;

public class LibtoolizeHandler
extends AbstractAutotoolsHandler {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "libtoolize";

    public Object execute(ExecutionEvent event) {
        return this.execute1(event);
    }

    @Override
    public void run(Shell activeShell) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = InvokeMessages.getString("CWD") + String.valueOf(this.getCWD(container));
        SingleInputDialog optionDialog = new SingleInputDialog(activeShell, cwd, InvokeMessages.getString("InvokeLibtoolizeAction.windowTitle.options"), InvokeMessages.getString("InvokeLibtoolizeAction.message.options.otherOptions"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        List<String> optionsList = this.simpleParseOptions(rawArgList);
        String libtoolizeCommand = null;
        IProject project = this.getSelectedContainer().getProject();
        try {
            libtoolizeCommand = project.getPersistentProperty(AutotoolsPropertyConstants.LIBTOOLIZE_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (libtoolizeCommand == null) {
            libtoolizeCommand = DEFAULT_COMMAND;
        }
        this.executeConsoleCommand(DEFAULT_COMMAND, libtoolizeCommand, optionsList, execDir);
    }
}

