/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddFiles
extends ProcessRunner {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject projectHandle = null;
        ProcessArgument[][] files = null;
        String startPattern = null;
        String endPattern = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals("files")) {
                files = arg.getComplexArrayValue();
            } else if (argName.equals("startPattern")) {
                startPattern = arg.getSimpleValue();
            } else if (argName.equals("endPattern")) {
                endPattern = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString("AddFiles.8")));
        }
        if (files == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString("AddFiles.9")));
        }
        int i = 0;
        while (i < files.length) {
            URL path;
            void file = files[i];
            String fileSourcePath = file[0].getSimpleValue();
            String fileTargetPath = file[1].getSimpleValue();
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                path = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, fileSourcePath);
                if (path == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString("AddFiles.1") + fileSourcePath));
                }
            }
            catch (IOException e1) {
                throw new ProcessFailureException(Messages.getString("AddFiles.2") + fileSourcePath);
            }
            InputStream contents = null;
            if (replaceable) {
                String fileContents;
                try {
                    fileContents = ProcessHelper.readFromFile(path);
                }
                catch (IOException e) {
                    throw new ProcessFailureException(Messages.getString("AddFiles.3") + fileSourcePath);
                }
                fileContents = startPattern != null && endPattern != null ? ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents, startPattern, endPattern), template.getValueStore(), startPattern, endPattern) : ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
                contents = new ByteArrayInputStream(fileContents.getBytes());
            } else {
                try {
                    contents = path.openStream();
                }
                catch (IOException e) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString("AddFiles.4") + fileSourcePath));
                }
            }
            try {
                IFile iFile = projectHandle.getFile(fileTargetPath);
                if (!iFile.getParent().exists()) {
                    ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                }
                if (iFile.exists()) {
                    if (!replaceable) throw new ProcessFailureException(Messages.getString("AddFiles.5"));
                    iFile.setContents(contents, true, true, null);
                } else {
                    iFile.create(contents, true, null);
                    iFile.refreshLocal(1, null);
                }
            }
            catch (CoreException e) {
                throw new ProcessFailureException(Messages.getString("AddFiles.6") + e.getMessage(), e);
            }
            ++i;
        }
        try {
            projectHandle.refreshLocal(2, null);
            return;
        }
        catch (CoreException e) {
            throw new ProcessFailureException(Messages.getString("AddFiles.7") + e.getMessage(), e);
        }
    }
}

