/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.util;

public class MementoTokenizer {
    private static final String CPROJECT = Character.toString('=');
    private static final String SOURCEROOT = Character.toString('/');
    private static final String SOURCEFOLDER = Character.toString('<');
    private static final String TRANSLATIONUNIT = Character.toString('{');
    private static final String SOURCEELEMENT = Character.toString('[');
    private static final String ELEMENTTYPE = Character.toString('#');
    private static final String PARAMETER = Character.toString('(');
    private final char[] memento;
    private final int length;
    private int index = 0;

    public MementoTokenizer(String memento) {
        this.memento = memento.toCharArray();
        this.length = this.memento.length;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        int start = this.index;
        StringBuilder buffer = null;
        switch (this.memento[this.index++]) {
            case '\\': {
                buffer = new StringBuilder();
                buffer.append(this.memento[this.index]);
                start = ++this.index;
                break;
            }
            case '=': {
                return CPROJECT;
            }
            case '/': {
                return SOURCEROOT;
            }
            case '<': {
                return SOURCEFOLDER;
            }
            case '{': {
                return TRANSLATIONUNIT;
            }
            case '[': {
                return SOURCEELEMENT;
            }
            case '#': {
                return ELEMENTTYPE;
            }
            case '(': {
                return PARAMETER;
            }
        }
        block14: while (this.index < this.length) {
            switch (this.memento[this.index]) {
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                    }
                    buffer.append(this.memento, start, this.index - start);
                    start = ++this.index;
                    break;
                }
                case '#': 
                case '(': 
                case '/': 
                case '<': 
                case '=': 
                case '[': 
                case '{': {
                    break block14;
                }
            }
            ++this.index;
        }
        if (buffer != null) {
            buffer.append(this.memento, start, this.index - start);
            return buffer.toString();
        }
        return new String(this.memento, start, this.index - start);
    }
}

