/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TmfTracingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TmfTracingPreferencePage() {
        super(1);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        BooleanFieldEditor explorerRange = new BooleanFieldEditor("EXPLORER_TIMERANGE", Messages.TmfTracingPreferencePage_TraceRangeInProjectExplorer, this.getFieldEditorParent());
        this.addField((FieldEditor)explorerRange);
        BooleanFieldEditor confirmDeletionSupplementaryFiles = new BooleanFieldEditor("CONFIRM_DELETION_SUPPLEMENTARY_FILES", Messages.TmfTracingPreferencePage_ConfirmDeletionSupplementaryFiles, this.getFieldEditorParent());
        this.addField((FieldEditor)confirmDeletionSupplementaryFiles);
        BooleanFieldEditor resourceRefresh = new BooleanFieldEditor("ALWAYS_CLOSE_ON_RESOURCE_CHANGE", Messages.TmfTracingPreferencePage_AlwaysCloseOnResourceChange, this.getFieldEditorParent());
        this.addField((FieldEditor)resourceRefresh);
        BooleanFieldEditor treeXyWarning = new BooleanFieldEditor("HIDE_MANY_ENTRIES_SELECTED_TOGGLE", Messages.TmfTracingPreferencePage_HideManyEntriesSelectedWarning, this.getFieldEditorParent());
        this.addField((FieldEditor)treeXyWarning);
        BooleanFieldEditor useBrowserTooltips = new BooleanFieldEditor("USE_HTML_TOOLTIPS", Messages.TmfTracingPreferencePage_UseBrowserTooltips, this.getFieldEditorParent());
        this.addField((FieldEditor)useBrowserTooltips);
        BooleanFieldEditor hideEmptyRows = new BooleanFieldEditor("FILTER_EMPTY_ROWS", Messages.TmfTracingPreferencePage_filterEmptyRowsTooltips, this.getFieldEditorParent());
        this.addField((FieldEditor)hideEmptyRows);
    }

    public boolean performOk() {
        boolean performOK = super.performOk();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TmfProjectElement projectElement = TmfProjectRegistry.getProject(project);
            if (projectElement != null) {
                projectElement.refresh();
            }
            ++n2;
        }
        return performOK;
    }
}

