/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import com.google.common.base.Joiner;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.model.StyleProperties;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;

public final class TimeGraphStyleUtil {
    private static final char SEPARATOR = '.';
    private static final String PREFIX = "view.";

    private TimeGraphStyleUtil() {
    }

    public static void loadValue(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem) {
        String prefColor;
        IPreferenceStore store = TimeGraphStyleUtil.getStore();
        String bgColorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "background-color");
        String colorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "color");
        String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "height");
        String widthKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "width");
        Map<String, Object> styleMap = stateItem.getStyleMap();
        String prefBgColor = store.getString(bgColorKey);
        if (!prefBgColor.isEmpty()) {
            styleMap.put("background-color", prefBgColor);
        }
        if (!(prefColor = store.getString(colorKey)).isEmpty()) {
            styleMap.put("color", prefColor);
        }
        store.setDefault(heightFactorKey, -1.0f);
        float prefHeightFactor = store.getFloat(heightFactorKey);
        if (prefHeightFactor != -1.0f) {
            styleMap.put("height", Float.valueOf(prefHeightFactor));
        }
        store.setDefault(widthKey, -1);
        int prefWidth = store.getInt(widthKey);
        if (prefWidth != -1) {
            styleMap.put("width", prefWidth);
        }
    }

    private static @Nullable Object getItemProperty(StateItem stateItem) {
        return stateItem.getStyleMap().get(StyleProperties.itemTypeProperty());
    }

    public static String getPreferenceName(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem, String styleKey) {
        return Joiner.on((char)'.').skipNulls().join((Object)(PREFIX + String.valueOf(presentationProvider.getPreferenceKey())), TimeGraphStyleUtil.getItemProperty(stateItem), new Object[]{stateItem.getStateString(), styleKey});
    }

    public static void loadValues(ITimeGraphPresentationProvider presentationProvider) {
        StateItem[] stateItemArray = presentationProvider.getStateTable();
        int n = stateItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateItem stateItem = stateItemArray[n2];
            TimeGraphStyleUtil.loadValue(presentationProvider, stateItem);
            ++n2;
        }
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

