/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralValue;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDerivedFromPath;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdEnumeratedValueDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdEnumerationDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class SvdFieldDMNode
extends SvdDMNode
implements Comparable<SvdDMNode> {
    private Integer fOffset = null;
    private Integer fWidth = null;
    private BigInteger fBigRepeatIncrement;
    private SvdEnumerationDMNode fReadEnumeration = null;
    private SvdEnumerationDMNode fWriteEnumeration = null;
    private String fResetValue = null;
    private String fResetMask = null;

    public SvdFieldDMNode(Leaf node) {
        super(node);
        this.prepareEnumerations();
    }

    @Override
    public void dispose() {
        this.fOffset = null;
        this.fWidth = null;
        if (this.fReadEnumeration != null) {
            this.fReadEnumeration.dispose();
            this.fReadEnumeration = null;
        }
        if (this.fWriteEnumeration != null) {
            this.fWriteEnumeration.dispose();
            this.fWriteEnumeration = null;
        }
        this.fResetValue = null;
        this.fResetMask = null;
        super.dispose();
    }

    private void prepareEnumerations() {
        block11: {
            block10: {
                SvdEnumerationDMNode enumeration;
                String element;
                if (this.getNode().getPackType() != Leaf.PACK_TYPE_CMSIS) break block10;
                if (((Node)this.getNode()).hasChildren()) {
                    for (Leaf child : ((Node)this.getNode()).getChildren()) {
                        element = "";
                        element = "enumeratedValues";
                        if (!child.isType(element)) continue;
                        enumeration = null;
                        enumeration = new SvdEnumerationDMNode(child);
                        if (this.fReadEnumeration == null && enumeration.isUsageRead()) {
                            this.fReadEnumeration = enumeration;
                        }
                        if (this.fWriteEnumeration != null || !enumeration.isUsageWrite()) continue;
                        this.fWriteEnumeration = enumeration;
                    }
                }
                if (this.fReadEnumeration != null && this.fWriteEnumeration != null) {
                    return;
                }
                if (this.getDerivedFromNode() == null || !this.getDerivedFromNode().hasChildren()) break block11;
                for (Leaf child : ((Node)this.getDerivedFromNode()).getChildren()) {
                    element = "";
                    element = "enumeratedValues";
                    if (!child.isType(element)) continue;
                    enumeration = null;
                    enumeration = new SvdEnumerationDMNode(child);
                    if (this.fReadEnumeration == null && enumeration.isUsageRead()) {
                        this.fReadEnumeration = enumeration;
                    }
                    if (this.fWriteEnumeration != null || !enumeration.isUsageWrite()) continue;
                    this.fWriteEnumeration = enumeration;
                }
                break block11;
            }
            if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK && ((Node)this.getNode()).hasChildren()) {
                for (Leaf child : ((Node)this.getNode()).getChildren()) {
                    if (!child.isType("enumerations") || !child.hasChildren()) continue;
                    for (Leaf grandChild : ((Node)child).getChildren()) {
                        if (!grandChild.isType("enumeration")) continue;
                        SvdEnumerationDMNode enumeration = new SvdEnumerationDMNode(grandChild);
                        if (this.fReadEnumeration == null && enumeration.isUsageRead()) {
                            this.fReadEnumeration = enumeration;
                        }
                        if (this.fWriteEnumeration != null || !enumeration.isUsageWrite()) continue;
                        this.fWriteEnumeration = enumeration;
                    }
                }
            }
        }
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createFieldPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                String clustersElement = "";
                if (node.getPackType() == Node.PACK_TYPE_CMSIS) {
                    clustersElement = "cluster";
                } else if (node.getPackType() == Node.PACK_TYPE_XPACK) {
                    clustersElement = "clusters";
                }
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    if (path.peripheralName == null) {
                        return true;
                    }
                    return path.peripheralName.equals(node.getName());
                }
                if (node.isType("registers")) {
                    return true;
                }
                if (node.isType(clustersElement)) {
                    return true;
                }
                if (node.isType("register")) {
                    if (path.registerName == null) {
                        return true;
                    }
                    return path.registerName.equals(node.getName());
                }
                if (node.isType("fields")) {
                    return true;
                }
                if (node.isType("field")) {
                    if (path.fieldName == null) {
                        return true;
                    }
                    return path.fieldName.equals(node.getName());
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("field");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("field")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    public boolean isEnumeration() {
        return this.fReadEnumeration != null;
    }

    public SvdEnumeratedValueDMNode findEnumeratedValue(PeripheralValue value) {
        if (this.fReadEnumeration == null) {
            return null;
        }
        SvdObjectDMNode[] children = this.fReadEnumeration.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((SvdEnumeratedValueDMNode)children[i]).isMatchForValue(value)) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("findEnumeratedValue(" + value + ") " + children[i]);
                }
                return (SvdEnumeratedValueDMNode)children[i];
            }
            ++i;
        }
        SvdEnumeratedValueDMNode defNode = this.fReadEnumeration.getDefaultEnumerationNode();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("findEnumeratedValue(" + value + ") default " + defNode);
        }
        return defNode;
    }

    public Integer findEnumeratedComboIndex(PeripheralValue value) {
        if (this.fWriteEnumeration == null) {
            return null;
        }
        SvdObjectDMNode[] children = this.fWriteEnumeration.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((SvdEnumeratedValueDMNode)children[i]).isMatchForValue(value)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public SvdEnumerationDMNode getWriteEnumerationDMNode() {
        return this.fWriteEnumeration;
    }

    public int getOffset() {
        if (this.fOffset == null) {
            try {
                String offset = this.getPropertyWithDerived("bitOffset");
                if (!offset.isEmpty()) {
                    this.fOffset = (int)SvdUtils.parseScaledNonNegativeLong(offset);
                } else {
                    String lsb = this.getPropertyWithDerived("lsb");
                    if (!lsb.isEmpty()) {
                        this.fOffset = (int)SvdUtils.parseScaledNonNegativeLong(lsb);
                    } else {
                        String bitRange = this.getPropertyWithDerived("bitRange");
                        if (!bitRange.isEmpty()) {
                            bitRange = bitRange.replace('[', ' ');
                            bitRange = bitRange.replace(']', ' ');
                            bitRange = bitRange.trim();
                            this.fOffset = (int)SvdUtils.parseScaledNonNegativeLong(bitRange.split(":")[1]);
                        } else {
                            Activator.log((String)("Missing offset, node " + this.getNode()));
                            this.fOffset = 0;
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                Activator.log((String)("Bad offset, node " + this.getNode()));
                this.fOffset = 0;
            }
        }
        return this.fOffset;
    }

    @Override
    public int getWidthBits() {
        if (this.fWidth == null) {
            try {
                String width = this.getPropertyWithDerived("bitWidth");
                if (!width.isEmpty()) {
                    this.fWidth = (int)SvdUtils.parseScaledNonNegativeLong(width);
                } else {
                    String msb = this.getPropertyWithDerived("msb");
                    if (!msb.isEmpty()) {
                        this.fWidth = (int)(SvdUtils.parseScaledNonNegativeLong(msb) - (long)this.getOffset() + 1L);
                    } else {
                        String bitRange = this.getPropertyWithDerived("bitRange");
                        if (!bitRange.isEmpty()) {
                            bitRange = bitRange.replace('[', ' ');
                            bitRange = bitRange.replace(']', ' ');
                            bitRange = bitRange.trim();
                            this.fWidth = (int)(SvdUtils.parseScaledNonNegativeLong(bitRange.split(":")[0]) - (long)this.getOffset() + 1L);
                        } else {
                            Activator.log((String)("Missing width, node " + this.getNode()));
                            this.fWidth = 1;
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                Activator.log((String)("Bad width, node " + this.getNode()));
                this.fWidth = 1;
            }
        }
        return this.fWidth;
    }

    @Override
    public BigInteger getBigRepeatIncrement() {
        if (this.fBigRepeatIncrement == null) {
            this.fBigRepeatIncrement = BigInteger.valueOf(this.getWidthBits());
            BigInteger repeatIncrement = this.getBigArrayAddressIncrement();
            if (repeatIncrement != BigInteger.ZERO && repeatIncrement.compareTo(this.fBigRepeatIncrement) > 0) {
                this.fBigRepeatIncrement = repeatIncrement;
            }
        }
        return this.fBigRepeatIncrement;
    }

    public String getResetValue() {
        if (this.fResetValue == null) {
            this.fResetValue = this.getPropertyWithDerivedWithParent("resetValue");
        }
        return this.fResetValue;
    }

    public String getResetMask() {
        if (this.fResetMask == null) {
            this.fResetMask = this.getPropertyWithDerivedWithParent("resetMask");
        }
        return this.fResetMask;
    }

    @Override
    public int compareTo(SvdDMNode comp) {
        if (comp instanceof SvdFieldDMNode) {
            return -(this.getOffset() - ((SvdFieldDMNode)comp).getOffset());
        }
        return 0;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", " + (this.getOffset() + this.getWidthBits() - 1) + "-" + this.getOffset() + ", " + this.getAccess() + ", \"" + this.getDescription() + "\"]";
    }
}

