/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;

public class BinConfigureOption
extends AbstractConfigurationOption {
    private boolean value;

    public BinConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
    }

    public BinConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
    }

    private BinConfigureOption(String name, AutotoolsConfiguration cfg, boolean value) {
        super(name, cfg);
        this.value = value;
    }

    @Override
    public boolean isParmSet() {
        return this.value;
    }

    @Override
    public String getParameter() {
        if (this.isParmSet()) {
            return this.getParameterName();
        }
        return "";
    }

    @Override
    public String getValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public void setValue(String value) {
        boolean oldValue = this.value;
        this.value = value.equals("true");
        if (this.value != oldValue) {
            this.cfg.setDirty(true);
        }
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new BinConfigureOption(this.name, config, this.value);
    }

    @Override
    public int getType() {
        return 1;
    }
}

