/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;

public class MultiArgConfigureOption
extends AbstractConfigurationOption {
    private String value;
    private List<String> userArgs;
    private boolean isDirty;

    public MultiArgConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = "";
    }

    public MultiArgConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
        this.value = "";
    }

    private MultiArgConfigureOption(String name, AutotoolsConfiguration cfg, String value) {
        super(name, cfg);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (!newValue.equals(this.value)) {
            this.cfg.setDirty(true);
            this.isDirty = true;
            this.value = newValue;
        }
    }

    @Override
    public boolean isParmSet() {
        return this.value.length() > 0;
    }

    @Override
    public boolean isMultiArg() {
        return true;
    }

    @Override
    public String getParameter() {
        return this.value;
    }

    @Override
    public List<String> getParameters() {
        if (!this.isDirty && this.userArgs != null) {
            return this.userArgs;
        }
        this.userArgs = new ArrayList<String>();
        this.isDirty = false;
        int lastArgIndex = -1;
        int i = 0;
        while (i < this.value.length()) {
            char ch = this.value.charAt(i);
            while (Character.isWhitespace(ch)) {
                if (++i < this.value.length()) {
                    ch = this.value.charAt(i);
                    continue;
                }
                return this.userArgs;
            }
            lastArgIndex = i;
            boolean inString = false;
            while (i < this.value.length()) {
                ch = this.value.charAt(i);
                if (ch == '\\') {
                    ++i;
                } else if (ch == '\"') {
                    inString = !inString;
                } else if (Character.isWhitespace(ch) && !inString) {
                    this.userArgs.add(this.value.substring(lastArgIndex, i));
                    break;
                }
                ++i;
            }
            if (i >= this.value.length()) {
                this.userArgs.add(this.value.substring(lastArgIndex));
            }
            ++i;
        }
        return this.userArgs;
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new MultiArgConfigureOption(this.name, config, this.value);
    }

    @Override
    public int getType() {
        return 4;
    }
}

