/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class LocalRunLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public LocalRunLaunchDelegate() {
        super(false);
    }

    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        assert (mode.equals("run"));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runLocalApplication(config, launch, monitor);
        }
    }

    private void runLocalApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_0, 10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            String args;
            IPath exePath = this.checkBinaryDetails(config);
            File wd = this.verifyWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            if ((args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "")).length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
            }
            String[] arguments = CommandLineUtil.argumentsToArray((String)args);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            monitor.worked(2);
            String[] commandArray = command.toArray(new String[command.size()]);
            String[] environment = this.getLaunchEnvironment(config);
            Process process = this.exec(commandArray, environment, wd);
            monitor.worked(6);
            String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
            String processLabel = String.format("%s (%s)", commandArray[0], timestamp);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)processLabel, this.createProcessAttributes());
        }
        finally {
            monitor.done();
        }
    }

    protected String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        String[] buildVars;
        ICProjectDescription projDesc;
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        IProject project = null;
        if (projectName == null) {
            IResource[] resources = config.getMappedResources();
            if (resources != null && resources.length > 0 && resources[0] instanceof IProject) {
                project = (IProject)resources[0];
            }
        } else if (!(projectName = projectName.trim()).isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        boolean append = config.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        boolean environmentCollectedFromProject = false;
        if (append && project != null && project.isAccessible() && (projDesc = CoreModel.getDefault().getProjectDescription(project, false)) != null) {
            IEnvironmentVariable[] vars;
            environmentCollectedFromProject = true;
            String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            ICConfigurationDescription cfg = null;
            if (buildConfigID.length() != 0) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
            ICdtVariableManager manager = CCorePlugin.getDefault().getCdtVariableManager();
            String[] stringArray = buildVars = manager.getVariables(cfg);
            int n3 = buildVars.length;
            int n4 = 0;
            while (n4 < n3) {
                String var = stringArray[n4];
                try {
                    if (!"project_classpath".equals(var.getName())) {
                        String value = manager.resolveValue(var.getStringValue(), "", File.pathSeparator, cfg);
                        envMap.put(var.getName(), value);
                    }
                }
                catch (CdtVariableException cdtVariableException) {
                    // empty catch block
                }
                ++n4;
            }
        }
        if (!environmentCollectedFromProject) {
            return DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        }
        ILaunchConfigurationWorkingCopy wc = config.copy("");
        wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
        String[] properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment((ILaunchConfiguration)wc);
        if (properties != null) {
            buildVars = properties;
            int n = properties.length;
            int vars = 0;
            while (vars < n) {
                String env = buildVars[vars];
                String[] parts = env.split("=", 2);
                if (parts.length == 2) {
                    envMap.put(parts[0], parts[1]);
                }
                ++vars;
            }
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected Map<String, String> createProcessAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
        attributes.put("org.eclipse.cdt.dsf.gdb.inferiorExited", "");
        return attributes;
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = this.verifyProgramPath(config, project);
        return exePath;
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory) throws CoreException {
        try {
            if (PTY.isSupported((PTY.Mode)PTY.Mode.CONSOLE)) {
                return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY());
            }
            return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory);
        }
        catch (IOException e) {
            this.abort(LaunchMessages.LocalCDILaunchDelegate_8, e, 150);
            return null;
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        this.setDefaultProcessFactory(config);
        return super.preLaunchCheck(config, mode, monitor);
    }

    protected void setDefaultProcessFactory(ILaunchConfiguration config) throws CoreException {
        if (!config.hasAttribute("process_factory_id")) {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
            wc.doSave();
        }
    }

    @Override
    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

